%dw 2.7

import * from com::mulesoft::connectivity::Model
import * from com::mulesoft::connectivity::decorator::Executor

fun defineValueProvider<InputType, OutputType, ErrorType, ProvidedValueType, DisplayPropertiesType <: Object, ConnectionType>(
    executor: Executor<InputType, OutputType, ResultFailure<ErrorType, Error>, ConnectionType>,
    fn: (OutputType) -> Array<ProvidedValue<ProvidedValueType, DisplayPropertiesType>> ): ValueProvider<InputType, ErrorType, ProvidedValueType, DisplayPropertiesType, ConnectionType> =
    executor mapSuccessResult fn($)

fun definePaginatedValueProvider<InputType, ItemType, ErrorType, ProvidedValueType, DisplayPropertiesType <: Object, ConnectionType, OpParamNextPage <: Object>(
  executor: Executor<InputType, Page<ItemType, OpParamNextPage>, ResultFailure<ErrorType, Error>, ConnectionType>,
  fn: (Page<ItemType, InputType>) -> Array<ProvidedValue<ProvidedValueType, DisplayPropertiesType>>
): PaginatedValueProvider<InputType, ErrorType, ProvidedValueType, DisplayPropertiesType, ConnectionType> = do {

    var e = executor mapSuccessResult (page) -> page update {
                case .items -> fn(page)
            }
---
    {executor: e, nextPageExecutor: e}
}

/**
* Transforms a value provider by applying a function on its failed results
*
* === Parameters
*
* [%header, cols="1,1,3"]
* |===
* | Name | Type | Description
* | `valueProvider` | ValueProvider<InputType, ErrorType, ProvidedValueType, ConnectionType> | The value provider to transform
* | `mapper` | &#40;ErrorType&#41; &#45;&#62; NewErrorType | A function that receives the error and transforms it to a _better_ error
* |===
*/
fun mapOutputFailureValueProvider<InputType, ErrorType, ProvidedValueType, DisplayPropertiesType <: Object, ConnectionType, NewErrorType>
  (valueProvider: ValueProvider<InputType, ErrorType, ProvidedValueType, DisplayPropertiesType, ConnectionType>,
    mapper: (ErrorType) -> ResultFailure<NewErrorType, Error>)
    : ValueProvider<InputType, NewErrorType, ProvidedValueType, DisplayPropertiesType, ConnectionType> =
    (inputType: InputType, connectionExecutorType: ConnectionType) ->
            valueProvider(inputType, connectionExecutorType) match {
                case is ResultSuccess<ProvidedValueType> -> $
                case is ResultFailure<ErrorType, Error> -> mapper($)
    }

fun mapOutputFailurePaginatedValueProvider<InputType, ErrorType, ProvidedValueType, DisplayPropertiesType <: Object, ConnectionType, NewErrorType>
  (valueProvider: PaginatedValueProvider<InputType, ErrorType, ProvidedValueType, DisplayPropertiesType, ConnectionType>,
    mapper: (ErrorType) -> ResultFailure<NewErrorType, Error>)
    : PaginatedValueProvider<InputType, NewErrorType, ProvidedValueType, DisplayPropertiesType, ConnectionType> = do {
      var e = (inputType: InputType, connectionExecutorType: ConnectionType) ->
        valueProvider.executor(inputType, connectionExecutorType) match {
              case is ResultSuccess<ProvidedValueType> -> $
              case is ResultFailure<ErrorType, Error> -> mapper($)
            }
      ---
      {executor: e, nextPageExecutor: e}
    }
