/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.parser.visitor;

import java.util.ArrayList;
import java.util.List;
import org.mule.raml.implv1.parser.rule.ValidationResultImpl;
import org.mule.raml.implv1.parser.visitor.RamlDocumentBuilderImpl;
import org.mule.raml.interfaces.parser.rule.IValidationResult;
import org.mule.raml.interfaces.parser.visitor.IRamlDocumentBuilder;
import org.mule.raml.interfaces.parser.visitor.IRamlValidationService;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlValidationService;

public class RamlValidationServiceImpl
implements IRamlValidationService {
    RamlDocumentBuilderImpl ramlDocumentBuilderImpl;
    List<IValidationResult> errors;
    List<IValidationResult> warnings;

    public RamlValidationServiceImpl(IRamlDocumentBuilder ramlDocumentBuilder) {
        this.ramlDocumentBuilderImpl = (RamlDocumentBuilderImpl)ramlDocumentBuilder.getInstance();
    }

    public IRamlValidationService validate(String resource) {
        return this.validate(null, resource);
    }

    public IRamlValidationService validate(String resourceContent, String resource) {
        ResourceLoader resourceLoader = this.ramlDocumentBuilderImpl.getResourceLoader();
        List results = RamlValidationService.createDefault((ResourceLoader)resourceLoader, (TagResolver[])new TagResolver[0]).validate(resourceContent, resource);
        this.errors = new ArrayList<IValidationResult>();
        for (ValidationResult validationResult : ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.ERROR, (List)results)) {
            this.errors.add(new ValidationResultImpl(validationResult));
        }
        this.warnings = new ArrayList<IValidationResult>();
        for (ValidationResult validationResult : ValidationResult.getLevel((ValidationResult.Level)ValidationResult.Level.WARN, (List)results)) {
            this.warnings.add(new ValidationResultImpl(validationResult));
        }
        return this;
    }

    public List<IValidationResult> getErrors() {
        return this.errors;
    }

    public List<IValidationResult> getWarnings() {
        return this.warnings;
    }
}

