/*
 * Decompiled with CFR 0.152.
 */
package org.mule.raml.implv1.injector;

import java.util.Map;
import org.mule.raml.implv1.injector.InjectableRamlFeature;
import org.raml.model.Action;
import org.raml.model.Response;

public class InjectableTrait
extends InjectableRamlFeature {
    private static final String RESOURCE = "/base";
    private static final String ACTION = "get";
    private static final String TEMPLATE_BEFORE = "#%RAML 0.8\ntitle: t\ntraits:\n - injected:\n";
    private static final String TEMPLATE_AFTER = "/base:\n get:\n  is: [injected]\n";
    private static final String INDENTATION = "    ";
    private Action cache;

    public InjectableTrait(String name, String yaml) {
        super(name, yaml);
    }

    @Override
    protected String getBoilerPlateBefore() {
        return TEMPLATE_BEFORE;
    }

    @Override
    protected String getBoilerPlateAfter() {
        return TEMPLATE_AFTER;
    }

    @Override
    protected String getIndentation() {
        return INDENTATION;
    }

    @Override
    public void applyToAction(Action target) {
        if (this.cache == null) {
            this.cache = this.parse().getResource(RESOURCE).getAction(ACTION);
        }
        Action source = this.resolveParams(target);
        this.mergeActions(target, source);
        target.getIs().add(this.name);
    }

    private void mergeActions(Action target, Action source) {
        this.putAllSkipExisting(target.getHeaders(), source.getHeaders());
        this.putAllSkipExisting(target.getQueryParameters(), source.getQueryParameters());
        if (source.getBody() != null) {
            this.putAllSkipExisting(target.getBody(), source.getBody());
        }
        for (Map.Entry response : source.getResponses().entrySet()) {
            if (target.getResponses().containsKey(response.getKey())) {
                this.putAllSkipExisting(((Response)target.getResponses().get(response.getKey())).getBody(), ((Response)response.getValue()).getBody());
                this.putAllSkipExisting(((Response)target.getResponses().get(response.getKey())).getHeaders(), ((Response)response.getValue()).getHeaders());
                continue;
            }
            target.getResponses().put(response.getKey(), response.getValue());
        }
    }

    private Action resolveParams(Action target) {
        return this.cache;
    }

    private <K, V> void putAllSkipExisting(Map<K, V> to, Map<K, V> from) {
        if (to != null && from != null) {
            for (Map.Entry<K, V> entry : from.entrySet()) {
                if (to.containsKey(entry.getKey())) continue;
                to.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

