/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote;

public class MessageBuilder {
    public static final String MESSAGE_TOKEN_SEPARATOR = ";";
    public static final String NUMBER_OF_TESTS_MSG_ID = "0;";
    public static final String NEW_TEST_MSG_ID = "1;";
    public static final String TEST_FAILURE_MSG_ID = "2;";
    public static final String TEST_ERROR_MSG_ID = "3;";
    public static final String TEST_FINSHED_MSG_ID = "4;";
    public static final String TEST_RUN_FINSHED_MSG_ID = "5;";
    public static final String TEST_IGNORED_MSG_ID = "6;";
    public static final String RUNTIME_START_FAILURE_MSG_ID = "7;";
    public static final String STACK_TRACE_MARKER = "'";

    public static String buildRuntimeStartFailureMessage(String fullMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append(RUNTIME_START_FAILURE_MSG_ID);
        builder.append(MESSAGE_TOKEN_SEPARATOR);
        builder.append(STACK_TRACE_MARKER);
        builder.append(fullMessage);
        builder.append(STACK_TRACE_MARKER);
        return builder.toString();
    }

    public static String buildNuberOfTestsMessage(String numberOfTests) {
        StringBuilder builder = new StringBuilder();
        builder.append(NUMBER_OF_TESTS_MSG_ID);
        builder.append(numberOfTests);
        return builder.toString();
    }

    public static String buildNewTestMessage(String testName) {
        StringBuilder builder = new StringBuilder();
        builder.append(NEW_TEST_MSG_ID);
        builder.append(testName);
        return builder.toString();
    }

    public static String buildTestErroMessage(String testName, String fullMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append(TEST_ERROR_MSG_ID);
        builder.append(testName);
        builder.append(MESSAGE_TOKEN_SEPARATOR);
        builder.append(STACK_TRACE_MARKER);
        builder.append(fullMessage);
        builder.append(STACK_TRACE_MARKER);
        return builder.toString();
    }

    public static String buildTestFailureMessage(String testName, String fullMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append(TEST_FAILURE_MSG_ID);
        builder.append(testName);
        builder.append(MESSAGE_TOKEN_SEPARATOR);
        builder.append(STACK_TRACE_MARKER);
        builder.append(fullMessage);
        builder.append(STACK_TRACE_MARKER);
        return builder.toString();
    }

    public static String buildTestIgnoredMessage(String testName) {
        StringBuilder builder = new StringBuilder();
        builder.append(TEST_IGNORED_MSG_ID);
        builder.append(testName);
        return builder.toString();
    }

    public static String buildTestFinishedMessage(String testName) {
        StringBuilder builder = new StringBuilder();
        builder.append(TEST_FINSHED_MSG_ID);
        builder.append(testName);
        return builder.toString();
    }

    public static String buildTestRunFinishedMessage(String testFullPath) {
        StringBuilder builder = new StringBuilder();
        builder.append(TEST_RUN_FINSHED_MSG_ID);
        builder.append(testFullPath);
        return builder.toString();
    }
}

