/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mocking;

import java.util.HashMap;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.modules.interceptor.processors.MessageProcessorBehavior;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.modules.interceptor.processors.MuleMessageTransformer;
import org.mule.munit.common.mocking.Attribute;
import org.mule.munit.common.mocking.CopyMessageTransformer;
import org.mule.munit.common.mocking.MunitMockingTool;
import org.mule.munit.common.mocking.NotDefinedPayload;
import org.mule.munit.common.mp.MockedMessageProcessorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageProcessorMocker
extends MunitMockingTool {
    public MessageProcessorMocker(MuleContext muleContext) {
        super(muleContext);
    }

    public MessageProcessorMocker when(String name) {
        this.messageProcessorName = name;
        return this;
    }

    public MessageProcessorMocker ofNamespace(String namespace) {
        this.messageProcessorNamespace = namespace;
        return this;
    }

    public MessageProcessorMocker withAttributes(Map<String, Object> attributes) {
        this.messageProcessorAttributes = attributes;
        return this;
    }

    public MessageProcessorMocker withAttributes(Attribute ... attributes) {
        HashMap<String, Object> mapOfAttributes = new HashMap<String, Object>();
        for (Attribute attribute : attributes) {
            mapOfAttributes.put(attribute.getId(), attribute.getValue());
        }
        this.messageProcessorAttributes = mapOfAttributes;
        return this;
    }

    public void thenReturn(MuleMessage message) {
        this.validateMessageProcessorName();
        MockedMessageProcessorManager manager = this.getManager();
        MessageProcessorCall messageProcessorCall = new MessageProcessorCall(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace));
        messageProcessorCall.setAttributes(this.messageProcessorAttributes);
        manager.addBehavior(new MessageProcessorBehavior(messageProcessorCall, (MuleMessageTransformer)new CopyMessageTransformer((DefaultMuleMessage)message)));
    }

    public void thenThrow(Throwable exception) {
        this.validateMessageProcessorName();
        MockedMessageProcessorManager manager = this.getManager();
        MessageProcessorCall messageProcessorCall = new MessageProcessorCall(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace));
        messageProcessorCall.setAttributes(this.messageProcessorAttributes);
        manager.addBehavior(new MessageProcessorBehavior(messageProcessorCall, exception));
    }

    public void thenReturnSameEvent() {
        this.validateMessageProcessorName();
        MockedMessageProcessorManager manager = this.getManager();
        MessageProcessorCall messageProcessorCall = new MessageProcessorCall(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace));
        messageProcessorCall.setAttributes(this.messageProcessorAttributes);
        manager.addBehavior(new MessageProcessorBehavior(messageProcessorCall, (MuleMessageTransformer)new CopyMessageTransformer(new DefaultMuleMessage((Object)NotDefinedPayload.getInstance(), this.muleContext))));
    }

    public void thenApply(MuleMessageTransformer transformer) {
        this.validateMessageProcessorName();
        MockedMessageProcessorManager manager = this.getManager();
        MessageProcessorCall messageProcessorCall = new MessageProcessorCall(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace));
        messageProcessorCall.setAttributes(this.messageProcessorAttributes);
        manager.addBehavior(new MessageProcessorBehavior(messageProcessorCall, transformer));
    }

    private void validateMessageProcessorName() {
        if (this.messageProcessorName == null) {
            throw new IllegalArgumentException("You must specify at least the message processor name");
        }
    }
}

