/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;
import org.mule.maven.pom.parser.api.MavenPomParser;
import org.mule.maven.pom.parser.api.model.AdditionalPluginDependencies;
import org.mule.maven.pom.parser.api.model.ArtifactCoordinates;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.maven.pom.parser.api.model.SharedLibrary;
import org.mule.maven.pom.parser.internal.model.MavenPomModelWrapper;
import org.mule.maven.pom.parser.internal.util.MavenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPomParserImpl
implements MavenPomParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenPomParserImpl.class);
    private final Pattern MAVEN_PROPERTY_PATTERN = Pattern.compile("(\\$\\{[^}]+})");
    private static final String MULE_MAVEN_PLUGIN_GROUP_ID = "org.mule.tools.maven";
    private static final String MULE_MAVEN_PLUGIN_ARTIFACT_ID = "mule-maven-plugin";
    private static final String MULE_EXTENSIONS_PLUGIN_GROUP_ID = "org.mule.runtime.plugins";
    private static final String MULE_EXTENSIONS_PLUGIN_ARTIFACT_ID = "mule-extensions-maven-plugin";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    public static final String SHARED_LIBRARIES_FIELD = "sharedLibraries";
    public static final String SHARED_LIBRARY_FIELD = "sharedLibrary";
    public static final String DEFAULT_SOURCES_DIRECTORY = "src/main";
    private static final String VERSION = "version";
    private static final String MAVEN_SHADE_PLUGIN_ARTIFACT_ID = "maven-shade-plugin";
    private static final String ORG_APACHE_MAVEN_PLUGINS_GROUP_ID = "org.apache.maven.plugins";
    private static final String ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD = "additionalPluginDependencies";
    private static final String PLUGIN_FIELD = "plugin";
    private static final String PLUGIN_DEPENDENCY_FIELD = "dependency";
    private static final String PLUGIN_DEPENDENCIES_FIELD = "additionalDependencies";
    private static final String DEFAULT_ARTIFACT_TYPE = "jar";
    private final Model pomModel;
    private final List<String> activeProfiles;
    private final Build build;

    public MavenPomParserImpl(Path path) {
        this(path, Collections.emptyList());
    }

    public MavenPomParserImpl(Path path, List<String> activeProfiles) {
        Objects.requireNonNull(path, "path cannot be null");
        this.pomModel = MavenUtils.getPomModel(path.toFile());
        this.activeProfiles = activeProfiles;
        this.build = this.pomModel.getBuild();
    }

    public String getSourceDirectory() {
        return this.build != null && this.build.getSourceDirectory() != null ? this.build.getSourceDirectory() : DEFAULT_SOURCES_DIRECTORY;
    }

    public List<String> getResourceDirectories() {
        return this.build != null ? this.build.getResources().stream().map(FileSet::getDirectory).collect(Collectors.toList()) : Collections.emptyList();
    }

    public MavenPomModel getModel() {
        return new MavenPomModelWrapper(this.pomModel);
    }

    public List<SharedLibrary> getSharedLibraries() {
        return this.findArtifactPackagerPlugin().stream().flatMap(this::getSharedLibrariesDom).findFirst().map(Stream::of).orElseGet(Stream::empty).map(sharedLibraryDom -> new SharedLibrary(this.getAttribute((Xpp3Dom)sharedLibraryDom, GROUP_ID), this.getAttribute((Xpp3Dom)sharedLibraryDom, ARTIFACT_ID))).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private Stream<Xpp3Dom[]> getSharedLibrariesDom(Plugin plugin) {
        Xpp3Dom sharedLibrariesDom;
        Object configuration = plugin.getConfiguration();
        if (configuration != null && (sharedLibrariesDom = ((Xpp3Dom)configuration).getChild(SHARED_LIBRARIES_FIELD)) != null) {
            return Stream.of(sharedLibrariesDom.getChildren(SHARED_LIBRARY_FIELD));
        }
        return Stream.empty();
    }

    public List<BundleDependency> getDependencies() {
        List dependencies = this.pomModel.getDependencies();
        Optional<Model> parentModel = this.loadParentModel(this.pomModel);
        while (parentModel.isPresent()) {
            dependencies.addAll(parentModel.get().getDependencies().stream().filter(dependency -> dependencies.stream().noneMatch(d -> d.getGroupId().equals(dependency.getGroupId()) && d.getArtifactId().equals(dependency.getArtifactId()) && d.getClassifier().equals(dependency.getClassifier()) && d.getType().equals(dependency.getType()))).collect(Collectors.toList()));
            parentModel = this.loadParentModel(parentModel.get());
        }
        return dependencies.stream().map(this::toBundleDependency).collect(Collectors.toList());
    }

    public Map<ArtifactCoordinates, AdditionalPluginDependencies> getPomAdditionalPluginDependenciesForArtifacts() {
        HashMap<ArtifactCoordinates, AdditionalPluginDependencies> pluginsAdditionalLibraries = new HashMap<ArtifactCoordinates, AdditionalPluginDependencies>();
        this.findArtifactPackagerPlugin().stream().flatMap(this::getAdditionalPluginDependenciesPluginsDom).findFirst().map(Stream::of).orElseGet(Stream::empty).forEach(pluginDom -> {
            String pluginGroupId = this.getChildParameterValue((Xpp3Dom)pluginDom, GROUP_ID, true);
            String pluginArtifactId = this.getChildParameterValue((Xpp3Dom)pluginDom, ARTIFACT_ID, true);
            ArrayList<BundleDescriptor> additionalDependencyDependencies = new ArrayList<BundleDescriptor>();
            Xpp3Dom dependenciesDom = pluginDom.getChild(PLUGIN_DEPENDENCIES_FIELD);
            if (dependenciesDom != null) {
                for (Xpp3Dom dependencyDom : dependenciesDom.getChildren(PLUGIN_DEPENDENCY_FIELD)) {
                    BundleDescriptor.Builder dependency = new BundleDescriptor.Builder();
                    dependency.setGroupId(this.getChildParameterValue(dependencyDom, GROUP_ID, true));
                    dependency.setArtifactId(this.getChildParameterValue(dependencyDom, ARTIFACT_ID, true));
                    dependency.setVersion(this.getChildParameterValue(dependencyDom, VERSION, true));
                    String type = this.getChildParameterValue(dependencyDom, "type", false);
                    dependency.setType(type == null ? DEFAULT_ARTIFACT_TYPE : type);
                    dependency.setClassifier(this.getChildParameterValue(dependencyDom, "classifier", false));
                    dependency.setSystemPath(this.getChildParameterValue(dependencyDom, "systemPath", false));
                    additionalDependencyDependencies.add(dependency.build());
                }
            }
            AdditionalPluginDependencies additionalPluginDependencies = new AdditionalPluginDependencies(pluginGroupId, pluginArtifactId, additionalDependencyDependencies);
            pluginsAdditionalLibraries.put(new ArtifactCoordinates(pluginGroupId, pluginArtifactId), additionalPluginDependencies);
        });
        return pluginsAdditionalLibraries;
    }

    private Stream<Xpp3Dom[]> getAdditionalPluginDependenciesPluginsDom(Plugin plugin) {
        Xpp3Dom additionalPluginDependenciesDom;
        Object configuration = plugin.getConfiguration();
        if (configuration != null && (additionalPluginDependenciesDom = ((Xpp3Dom)configuration).getChild(ADDITIONAL_PLUGIN_DEPENDENCIES_FIELD)) != null) {
            return Stream.of(additionalPluginDependenciesDom.getChildren(PLUGIN_FIELD));
        }
        return Stream.empty();
    }

    public Properties getProperties() {
        Properties properties = this.pomModel.getProperties();
        Optional<Model> parentModel = this.loadParentModel(this.pomModel);
        while (parentModel.isPresent()) {
            properties.putAll(parentModel.get().getProperties().entrySet().stream().filter(property -> properties.keySet().stream().noneMatch(key -> key.equals(property.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            parentModel = this.loadParentModel(parentModel.get());
        }
        return properties;
    }

    public boolean isMavenShadePluginConfigured() {
        if (this.pomModel.getBuild() != null) {
            for (Plugin plugin : this.pomModel.getBuild().getPlugins()) {
                if (!plugin.getGroupId().equals(ORG_APACHE_MAVEN_PLUGINS_GROUP_ID) || !plugin.getArtifactId().equals(MAVEN_SHADE_PLUGIN_ARTIFACT_ID)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Plugin> findArtifactPackagerPlugin() {
        Stream basePlugin = Stream.empty();
        Optional<Object> pluginManagementPlugin = Optional.empty();
        Build build = this.pomModel.getBuild();
        if (build != null) {
            basePlugin = this.findArtifactPackagerPlugin(build.getPlugins()).map(Stream::of).orElse(Stream.empty());
            pluginManagementPlugin = this.findArtifactPackagerPlugin(build.getPluginManagement());
        }
        List sortedActiveProfiles = this.activeProfiles.stream().sorted(String::compareTo).collect(Collectors.toList());
        Stream<Plugin> packagerConfigsForActivePluginsStream = this.pomModel.getProfiles().stream().filter(profile -> sortedActiveProfiles.contains(profile.getId())).map(profile -> this.findArtifactPackagerPlugin(profile.getBuild() != null ? profile.getBuild().getPlugins() : null)).filter(plugin -> !plugin.equals(Optional.empty())).map(Optional::get);
        Optional<Plugin> plugin2 = Stream.concat(basePlugin, packagerConfigsForActivePluginsStream).reduce((p1, p2) -> {
            p1.setConfiguration((Object)Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)((Xpp3Dom)p2.getConfiguration()), (Xpp3Dom)((Xpp3Dom)p1.getConfiguration())));
            p1.getDependencies().addAll(p2.getDependencies());
            return p1;
        });
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugin2.ifPresent(plugins::add);
        pluginManagementPlugin.ifPresent(plugins::add);
        this.loadParentModel(this.pomModel).ifPresent(pm -> plugins.addAll(this.findArtifactPackagerPluginInParents((Model)pm)));
        return plugins;
    }

    private List<Plugin> findArtifactPackagerPluginInParents(Model parentModel) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (parentModel.getBuild() != null) {
            this.findArtifactPackagerPlugin(parentModel.getBuild().getPlugins()).ifPresent(plugins::add);
            this.findArtifactPackagerPlugin(parentModel.getBuild().getPluginManagement()).ifPresent(plugins::add);
        }
        this.loadParentModel(parentModel).ifPresent(pm -> plugins.addAll(this.findArtifactPackagerPluginInParents((Model)pm)));
        return plugins;
    }

    private Optional<Plugin> findArtifactPackagerPlugin(PluginManagement pluginManagement) {
        if (pluginManagement != null && pluginManagement.getPlugins() != null) {
            return this.findArtifactPackagerPlugin(pluginManagement.getPlugins());
        }
        return Optional.empty();
    }

    private Optional<Plugin> findArtifactPackagerPlugin(List<Plugin> plugins) {
        if (plugins == null) {
            return Optional.empty();
        }
        return plugins.stream().filter(plugin -> plugin.getArtifactId().equals(MULE_MAVEN_PLUGIN_ARTIFACT_ID) && plugin.getGroupId().equals(MULE_MAVEN_PLUGIN_GROUP_ID) || plugin.getArtifactId().equals(MULE_EXTENSIONS_PLUGIN_ARTIFACT_ID) && plugin.getGroupId().equals(MULE_EXTENSIONS_PLUGIN_GROUP_ID)).findFirst();
    }

    private String getAttribute(Xpp3Dom tag, String attributeName) {
        Xpp3Dom attributeDom = tag.getChild(attributeName);
        this.checkState(attributeDom != null, String.format("'%s' element not declared at '%s' in the pom file", attributeName, tag));
        String attributeValue = attributeDom.getValue().trim();
        this.checkState(!StringUtils.isEmpty((String)attributeValue), String.format("'%s' was defined but has an empty value at '%s' declared in the pom file", attributeName, tag));
        return attributeValue;
    }

    private String getChildParameterValue(Xpp3Dom element, String childName, boolean validate) {
        String childValue;
        Xpp3Dom child = element.getChild(childName);
        String string = childValue = child != null ? child.getValue() : null;
        if (StringUtils.isEmpty((String)childValue) && validate) {
            throw new IllegalArgumentException("Expecting child element with not null value " + childName);
        }
        if (StringUtils.isEmpty((String)childValue)) {
            return childValue;
        }
        int lastIndex = 0;
        StringBuilder output = new StringBuilder();
        Matcher matcher = this.MAVEN_PROPERTY_PATTERN.matcher(childValue);
        while (matcher.find()) {
            String propertyValue = this.resolvePropertyValue(matcher.group(1).substring(2, matcher.group(1).length() - 1));
            if (propertyValue != null) {
                output.append(childValue, lastIndex, matcher.start()).append(propertyValue);
            } else {
                output.append(childValue, lastIndex, matcher.start()).append(matcher.group(1));
            }
            lastIndex = matcher.end();
        }
        if (lastIndex < childValue.length()) {
            output.append(childValue, lastIndex, childValue.length());
        }
        return output.toString();
    }

    private String resolvePropertyValue(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null) {
            propertyValue = this.getProperties().getProperty(propertyName);
        }
        return propertyValue;
    }

    private BundleDependency toBundleDependency(Dependency dependency) {
        BundleDescriptor descriptor = new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setType(dependency.getType()).setExclusions(dependency.getExclusions().stream().map(exclusion -> new ArtifactCoordinates(exclusion.getGroupId(), exclusion.getArtifactId())).collect(Collectors.toList())).setClassifier(dependency.getClassifier()).setOptional(dependency.getOptional()).setSystemPath(dependency.getSystemPath()).build();
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(descriptor);
        if (dependency.getScope() != null && !dependency.getScope().isEmpty()) {
            builder.setScope(BundleScope.valueOf((String)dependency.getScope().toUpperCase()));
        }
        return builder.build();
    }

    private Optional<Model> loadParentModel(Model model) {
        File parentPomFile;
        Parent parent = model.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        File currentPomFile = model.getPomFile();
        if (currentPomFile == null) {
            return Optional.empty();
        }
        String relativePath = parent.getRelativePath();
        if (relativePath == null || relativePath.isEmpty()) {
            relativePath = "../pom.xml";
        }
        if (!(parentPomFile = new File(currentPomFile.getParentFile(), relativePath)).exists()) {
            return Optional.empty();
        }
        if (parentPomFile.isDirectory()) {
            parentPomFile = new File(parentPomFile, "pom.xml");
        }
        if (!parentPomFile.exists()) {
            return Optional.empty();
        }
        try {
            return Optional.of(MavenUtils.getPomModel(parentPomFile));
        }
        catch (Exception e) {
            LOGGER.debug("Couldn't load parent model from '{}' for '{}'", (Object)parentPomFile, (Object)model);
            return Optional.empty();
        }
    }

    private void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }
}

