/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.internal.model;

import org.mule.maven.pom.parser.api.model.PomParentCoordinates;

import org.apache.maven.model.Parent;

public class PomParentCoordinatesWrapper implements PomParentCoordinates {

  private final String groupId;
  private final String artifactId;
  private final String version;

  public PomParentCoordinatesWrapper(Parent parent) {
    this.groupId = parent.getGroupId();
    this.artifactId = parent.getArtifactId();
    this.version = parent.getVersion();
  }

  @Override
  public String getGroupId() {
    return groupId;
  }

  @Override
  public String getArtifactId() {
    return artifactId;
  }

  @Override
  public String getVersion() {
    return version;
  }
}
