/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.internal.util;

import static java.nio.file.Paths.get;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;

public class TestUtils {

  public static Path getPath(String file) {
    try {
      return get(getResource(file).toURI());
    } catch (URISyntaxException e) {
      throw new RuntimeException(e);
    }
  }

  public static Path getFile(Path file) {
    try {
      return get(getResource(file.toString()).toURI());
    } catch (URISyntaxException e) {
      throw new RuntimeException(e);
    }
  }

  private static URL getResource(String file) {
    return TestUtils.class.getClassLoader().getResource(file);
  }


}

