/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Maven parser implementation to work with maven artifacts.
 *
 * @moduleGraph
 * @since 2.0
 */
module org.mule.runtime.maven.pom.parser.impl {

  requires org.mule.runtime.maven.model.shaded;
  requires org.mule.runtime.maven.pom.parser.api;

  requires org.apache.commons.io;
  requires org.apache.maven.resolver;
  requires org.apache.maven.resolver.util;
  requires plexus.utils;
  requires plexus.xml;

  exports org.mule.maven.pom.parser.internal to
      org.mule.runtime.maven.client.impl,
      org.mule.runtime.maven.client.test;
  exports org.mule.maven.pom.parser.internal.model to
      org.mule.runtime.maven.client.impl,
      org.mule.runtime.maven.client.test;
  exports org.mule.maven.pom.parser.internal.util to
      org.mule.runtime.maven.client.impl,
      org.mule.runtime.maven.client.test;

  provides org.mule.maven.pom.parser.api.MavenPomParserProvider
      with org.mule.maven.pom.parser.internal.MuleMavenPomParserProvider;
  provides org.mule.maven.pom.parser.api.model.MavenModelBuilderProvider
      with org.mule.maven.pom.parser.internal.model.MuleMavenModelBuilderProvider;

}
