/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.pom.parser.api.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;

public class BundleDependency {
    private BundleDescriptor descriptor;
    private BundleScope scope;
    private URI bundleUri;
    private List<BundleDependency> transitiveDependencies = new ArrayList<BundleDependency>();

    protected BundleDependency() {
    }

    public BundleScope getScope() {
        return this.scope;
    }

    public BundleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public URI getBundleUri() {
        return this.bundleUri;
    }

    public List<BundleDependency> getTransitiveDependencies() {
        return this.transitiveDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleDependency that = (BundleDependency)o;
        return this.descriptor.equals(that.descriptor) && this.scope == that.scope;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.descriptor, this.scope});
    }

    public String toString() {
        return "BundleDependency{descriptor=" + this.descriptor + ", scope=" + (Object)((Object)this.scope) + ", bundleUrl=" + this.bundleUri + '}';
    }

    private static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static class Builder {
        private static final String BUNDLE_DESCRIPTOR = "bundle descriptor";
        private static final String REQUIRED_FIELD_NOT_FOUND_TEMPLATE = "bundle cannot be created with null or empty %s";
        private static final String REQUIRED_FIELD_IS_NULL = "bundle cannot be created with null %s";
        private BundleDependency bundleDependency = new BundleDependency();

        public Builder setDescriptor(BundleDescriptor descriptor) {
            this.validateIsNotNull(descriptor, BUNDLE_DESCRIPTOR);
            this.bundleDependency.descriptor = descriptor;
            return this;
        }

        public Builder setScope(BundleScope scope) {
            BundleDependency.checkState(scope != null, "scope cannot be null");
            this.bundleDependency.scope = scope;
            return this;
        }

        public Builder setBundleDescriptor(BundleDescriptor descriptor) {
            this.validateIsNotNull(descriptor, BUNDLE_DESCRIPTOR);
            this.bundleDependency.descriptor = descriptor;
            return this;
        }

        public Builder setBundleUri(URI bundleUri) {
            this.validateIsNotNull(bundleUri, "Bundle URI cannot be null");
            this.bundleDependency.bundleUri = bundleUri;
            return this;
        }

        public Builder addTransitiveDependency(BundleDependency bundleDependency) {
            this.validateIsNotNull(bundleDependency, "Bundle dependency cannot be null");
            this.bundleDependency.transitiveDependencies.add(bundleDependency);
            return this;
        }

        public BundleDependency build() {
            this.validateIsNotNull(this.bundleDependency.descriptor, BUNDLE_DESCRIPTOR);
            return this.bundleDependency;
        }

        private String getEmptyFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_NOT_FOUND_TEMPLATE, field);
        }

        private String getNullFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_IS_NULL, field);
        }

        private void validateIsNotEmpty(String value, String fieldId) {
            BundleDependency.checkState(!Builder.isEmpty(value), this.getEmptyFieldMessage(fieldId));
        }

        private static boolean isEmpty(String value) {
            return value == null || value.equals("");
        }

        private void validateIsNotNull(Object value, String fieldId) {
            BundleDependency.checkState(value != null, this.getNullFieldMessage(fieldId));
        }
    }
}

