/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.pom.parser.api.model;

/**
 * Describes a Parent in a pom
 *
 * @since 2.0.0
 */
public interface PomParentCoordinates {

  /**
   * Gets the group id of the Model.
   *
   * @return the group id
   */
  String getGroupId();

  /**
   * Gets the artifact id of the Model.
   *
   * @return the artifact id
   */
  String getArtifactId();

  /**
   * Gets the version of the Model.
   *
   * @return the version
   */
  String getVersion();
}
