/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.api.model.RemoteRepository.newRemoteRepositoryBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.BlockHttpRepositoryStory.BLOCK_HTTP_REPOSITORIES;

import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;

import java.net.MalformedURLException;
import java.net.URL;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import io.qameta.allure.Link;
import io.qameta.allure.Story;
import org.junit.Test;

@Story(BLOCK_HTTP_REPOSITORIES)
@Issue("W-12337231")
@Link("https://maven.apache.org/docs/3.8.1/release-notes.html")
public class BlockHTTPRepositoriesTestCase extends AbstractMavenClientTestCase {

  @Override
  protected void beforeTest() throws Exception {
    mavenClient = mavenClientProvider.createMavenClient(createMavenConfiguration());
  }

  @Test
  @Description("HTTP repositories must be blocked by default")
  public void resolveDependencyWithHttpMustFailWithBlockedRepository() {
    try {
      mavenClient.resolveBundleDescriptor(new BundleDescriptor.Builder()
          .setGroupId("groupId")
          .setArtifactId("zaraza")
          .setVersion("0.0.1")
          .build());
    } catch (BundleDependenciesResolutionException e) {
      assertThat(e.getMessage(), containsString("maven-default-http-blocker (http://0.0.0.0/)"));
    }
  }

  protected MavenConfiguration createMavenConfiguration() throws MalformedURLException {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(repositoryFolder.getRoot())
        .remoteRepository(newRemoteRepositoryBuilder()
            .id("http-repo")
            .url(new URL("http://zaraza.http/")).build())
        .build();
  }
}
