/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.test;

import static org.mule.maven.client.api.model.MavenConfiguration.newMavenConfigurationBuilder;
import static org.mule.maven.client.test.AllureConstants.MavenClient.MAVEN_CLIENT;

import static java.util.Optional.empty;

import static org.apache.commons.io.FileUtils.toFile;
import static org.hamcrest.Matchers.containsString;
import static org.hamcrest.Matchers.isA;
import static org.junit.internal.matchers.ThrowableCauseMatcher.hasCause;
import static org.junit.internal.matchers.ThrowableMessageMatcher.hasMessage;

import org.mule.maven.client.api.model.MavenConfiguration;

import java.io.File;
import java.io.IOException;

import io.qameta.allure.Story;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.junit.Test;

@Story(MAVEN_CLIENT)
public class IgnorePomRepositoriesResolvingArtifactDepdendenciesTestCase extends AbstractMavenClientTestCase {

  @Override
  protected void beforeTest() {}

  private MavenConfiguration createMavenConfiguration(File localRepository) {
    return newMavenConfigurationBuilder()
        .localMavenRepositoryLocation(localRepository)
        .ignoreArtifactDescriptorRepositories(true)
        .build();
  }

  @Test
  public void shouldNotUseMavenCentralToResolveDependencies() throws IOException {
    mavenClient = mavenClientProvider.createMavenClient(createMavenConfiguration(temporaryFolder.newFolder()));
    File artifactFile =
        toFile(getClass().getClassLoader().getResource("pom-resolve-artifact-ignore-remote-repositories/pom.xml"));

    expectedException.expect(RuntimeException.class);
    expectedException.expectCause(hasCause(isA(DependencyCollectionException.class)));
    expectedException.expectCause(hasCause(hasMessage(containsString("commons-io:commons-io:jar:1.2"))));
    mavenClient.resolveArtifactDependencies(artifactFile, false, false, empty(), empty());
  }

}
