/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Supplier;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.maven.pom.parser.internal.util.FileUtils;

public final class MavenTestUtils {
    private static final String POM_XML = "pom.xml";
    private static final String JAR = ".jar";

    private MavenTestUtils() {
    }

    public static String getMavenProperty(String property, Supplier<File> pomFolderFinder) {
        String propertyValue = System.getProperty(property);
        if (propertyValue != null) {
            return propertyValue;
        }
        Model mavenProject = MavenTestUtils.mavenProject(pomFolderFinder);
        propertyValue = (String)mavenProject.getProperties().get(property);
        return MavenTestUtils.resolveMavenProperty(propertyValue, mavenProject);
    }

    public static String getMavenProjectVersion(Supplier<File> pomFolderFinder) {
        Model mavenProject = MavenTestUtils.mavenProject(pomFolderFinder);
        String muleVersion = MavenTestUtils.resolveMavenProperty(mavenProject.getVersion(), mavenProject);
        if (muleVersion != null) {
            return muleVersion;
        }
        return mavenProject.getParent().getVersion();
    }

    public static Supplier<File> mavenPomFinder(Class clazz) {
        return () -> {
            try {
                return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParentFile().getParentFile();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        };
    }

    private static Model mavenProject(Supplier<File> pomFolderFinder) {
        return MavenTestUtils.createMavenProject(pomFolderFinder.get());
    }

    private static String resolveMavenProperty(String propertyValue, Model mavenProject) {
        if (propertyValue != null && propertyValue.startsWith("${") && propertyValue.endsWith("}")) {
            String property = propertyValue.substring(propertyValue.indexOf("{") + 1, propertyValue.lastIndexOf("}"));
            return mavenProject.getProperties().get(property).toString();
        }
        return propertyValue;
    }

    private static Model createMavenProject(File pomFile) {
        if (pomFile != null && pomFile.exists()) {
            Model model;
            if (pomFile.isFile() && pomFile.getName().endsWith(JAR)) {
                try {
                    MavenXpp3Reader reader = new MavenXpp3Reader();
                    return reader.read((InputStream)new ByteArrayInputStream((byte[])org.mule.maven.client.internal.util.FileUtils.loadFileContentFrom((URL)FileUtils.getPomUrlFromJar((File)pomFile)).get()));
                }
                catch (IOException | XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            }
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            FileReader reader = new FileReader(new File(pomFile, POM_XML));
            try {
                Model model2 = mavenReader.read((Reader)reader);
                model2.setPomFile(pomFile);
                model = model2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't get Maven Artifact from pom: " + pomFile, e);
                }
            }
            reader.close();
            return model;
        }
        throw new IllegalArgumentException("pom file doesn't exits for path: " + pomFile);
    }
}

