/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.version;

import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionConstraint;

public class MavenVersionConstraintParser {

  private final VersionConstraint containsVersion;

  public MavenVersionConstraintParser(String version) throws InvalidVersionSpecificationException {
    this.containsVersion = new GenericVersionScheme().parseVersionConstraint(version);
  }

  public boolean containsVersion(MavenVersion version) {
    return containsVersion.containsVersion(version.getVersion());
  }
}
