/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.repository;

import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;

/**
 * Manages an instance of Maven's {@link RepositorySystem}, along with some of its components.
 *
 * @since 2.0
 */
public interface MuleRepositorySystemManager extends AutoCloseable {

  static MuleRepositorySystemManager getManager() {
    return MavenMuleRepositorySystemManager.getInstance() != null ? MavenMuleRepositorySystemManager.getInstance()
        : new StandaloneMuleRepositorySystemManager();
  }

  /**
   * @return the {@link RepositorySystem}.
   */
  RepositorySystem getRepositorySystem();

  /**
   * @return the {@link RepositorySystem}'s {@link ArtifactResolver}.
   */
  ArtifactResolver getArtifactResolver();

  /**
   * @return the {@link RepositorySystem}'s {@link VersionRangeResolver}.
   */
  VersionRangeResolver getVersionRangeResolver();

  /**
   * @return the {@link RepositorySystem}'s {@link RemoteRepositoryManager}.
   */
  RemoteRepositoryManager getRemoteRepositoryManager();

}
