/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Mule Maven Client Implementation.
 *
 * @moduleGraph
 * @since 2.0
 */
module org.mule.runtime.maven.client.impl {

  requires org.mule.runtime.maven.client.api;
  requires transitive org.mule.runtime.maven.pom.parser.api;
  requires org.mule.runtime.maven.pom.parser.impl;
  requires org.mule.runtime.maven.model.shaded;

  requires javax.inject;
  requires jcommander;
  requires maven.builder.support;
  requires maven.resolver.provider;
  requires maven.settings;
  requires maven.settings.builder;
  // required by wagon.http.shared
  requires org.apache.commons.codec;
  requires org.apache.commons.logging;
  requires org.apache.httpcomponents.httpclient;
  requires org.apache.maven.resolver;
  requires org.apache.maven.resolver.impl;
  requires org.apache.maven.resolver.named.locks;
  requires org.apache.maven.resolver.spi;
  requires org.apache.maven.resolver.supplier;
  requires org.apache.maven.resolver.transport.file;
  requires org.apache.maven.resolver.transport.http;
  requires org.apache.maven.resolver.transport.wagon;
  requires org.apache.maven.resolver.util;
  requires org.slf4j;
  requires org.eclipse.sisu.plexus;
  requires org.eclipse.sisu.inject;
  requires plexus.cipher;
  requires plexus.component.annotations;
  requires plexus.sec.dispatcher;
  requires semver4j;
  requires wagon.http;
  requires wagon.http.shared;
  requires wagon.provider.api;

  requires org.apache.commons.io;

  exports org.mule.maven.client.internal to
      org.mule.runtime.maven.client.test,
      org.mule.test.runner;
  exports org.mule.maven.client.internal.util to
      org.mule.runtime.maven.client.test,
      org.mule.test.runner;
  exports org.mule.maven.client.internal.wagon to
      org.mule.runtime.maven.model.shaded;

  provides org.mule.maven.client.api.MavenClientProvider
      with org.mule.maven.client.internal.MuleMavenClientProvider;

  provides org.mule.maven.client.api.VersionUtils
      with org.mule.maven.client.internal.version.DefaultVersionUtils;

  opens org.mule.maven.client.internal to
      jcommander;

  uses org.mule.maven.client.internal.MuleMavenConcurrentLocalRepository;

}
