/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import org.mule.maven.client.api.EnvironmentConfiguration;

import static org.mule.maven.client.internal.MuleEnvironmentConfiguration.MULE_SECURITY_MODEL_PROPERTY;
import static org.mule.maven.client.internal.MuleEnvironmentConfiguration.resetConfiguration;

import static java.lang.Boolean.FALSE;
import static java.lang.Boolean.TRUE;
import static java.lang.System.clearProperty;
import static java.lang.System.setProperty;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

import org.junit.Before;
import org.junit.Test;

public class MuleEnvironmentConfigurationTest {

  public static final String TEST_NON_FIPS_MODEL = "non-fips-model";
  private final String ORIGINAL_SECURITY_MODEL =
      System.getProperty(MULE_SECURITY_MODEL_PROPERTY);

  @Before
  public void clearSystemProperty() {
    if (ORIGINAL_SECURITY_MODEL != null) {
      setProperty(MULE_SECURITY_MODEL_PROPERTY, ORIGINAL_SECURITY_MODEL);
    } else {
      clearProperty(MULE_SECURITY_MODEL_PROPERTY);
    }
  }

  @Test
  public void testIsFipsEnvironmentWhenFips1402() {
    setProperty(MULE_SECURITY_MODEL_PROPERTY,
                MuleEnvironmentConfiguration.FIPS_140_2_SECURITY_MODEL);
    resetConfiguration();
    EnvironmentConfiguration config = MuleEnvironmentConfiguration.getInstance();
    assertThat(config.isFipsEnvironment(), equalTo(TRUE));
  }

  @Test
  public void testIsFipsEnvironmentWhenNotFips1402() {
    setProperty(MULE_SECURITY_MODEL_PROPERTY, TEST_NON_FIPS_MODEL);
    resetConfiguration();
    EnvironmentConfiguration config = MuleEnvironmentConfiguration.getInstance();
    assertThat(config.isFipsEnvironment(), equalTo(FALSE));
  }

  @Test
  public void testIsFipsEnvironmentWhenPropertyNotSet() {
    clearProperty(MULE_SECURITY_MODEL_PROPERTY);
    resetConfiguration();
    EnvironmentConfiguration config = MuleEnvironmentConfiguration.getInstance();
    assertThat(config.isFipsEnvironment(), equalTo(FALSE));
  }
}
