/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.wagon;

import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.http.HttpWagon;
import org.eclipse.aether.transport.wagon.WagonProvider;

/**
 * An implementation of {@link WagonProvider} which creates only the providers that we need. Aether provides an implementation
 * that uses {@link PlexusContainer} but we need to keep this simple.
 */
public class SimplePlexusWagonProvider implements WagonProvider {

  @Override
  public Wagon lookup(String roleHint) throws Exception {
    if ("https".equals(roleHint)) {
      return new HttpWagon();
    } else if ("http".equals(roleHint)) {
      return new HttpWagon();
    }
    throw new IllegalArgumentException("No wagon available for " + roleHint);
  }

  @Override
  public void release(Wagon wagon) {}

}
