/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.repository;

import javax.inject.Inject;
import javax.inject.Named;

import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.sisu.EagerSingleton;

/**
 * {@link MuleRepositorySystemManager} implementation to be used when running within a Maven context (for example within a Maven
 * Plugin like the Mule applications or the Mule extensions packager).
 *
 * @since 2.0
 */
@Named
@EagerSingleton
@Component(role = MavenMuleRepositorySystemManager.class, instantiationStrategy = "load-on-start")
public class MavenMuleRepositorySystemManager implements MuleRepositorySystemManager {

  private static MuleRepositorySystemManager INSTANCE;

  private RepositorySystem repositorySystem;

  private final ArtifactResolver artifactResolver;

  private final VersionRangeResolver versionRangeResolver;
  private final RemoteRepositoryManager remoteRepositoryManager;

  @Inject
  private MavenMuleRepositorySystemManager(RepositorySystem repositorySystem, ArtifactResolver artifactResolver,
                                           VersionRangeResolver versionRangeResolver,
                                           RemoteRepositoryManager remoteRepositoryManager) {
    this.repositorySystem = repositorySystem;
    this.artifactResolver = artifactResolver;
    this.versionRangeResolver = versionRangeResolver;
    this.remoteRepositoryManager = remoteRepositoryManager;

    INSTANCE = this;
  }

  public static MuleRepositorySystemManager getInstance() {
    return INSTANCE;
  }

  @Override
  public RepositorySystem getRepositorySystem() {
    return repositorySystem;
  }

  @Override
  public ArtifactResolver getArtifactResolver() {
    return artifactResolver;
  }

  @Override
  public VersionRangeResolver getVersionRangeResolver() {
    return versionRangeResolver;
  }

  @Override
  public RemoteRepositoryManager getRemoteRepositoryManager() {
    return remoteRepositoryManager;
  }

  @Override
  public void close() {
    // Nothing to do
  }

}
