/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import java.util.List;

import org.apache.maven.model.resolution.ModelResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.repository.RemoteRepository;

/**
 * Default implementation of {@link MuleMavenRepositoryState}.
 */
public class DefaultMuleMavenRepositoryState implements MuleMavenRepositoryState {

  private final DefaultRepositorySystemSession repositorySystemSession;
  private final RepositorySystem repositorySystem;
  private final ArtifactResolver artifactResolver;
  private final VersionRangeResolver versionRangeResolver;
  private final RemoteRepositoryManager remoteRepositoryManager;

  public DefaultMuleMavenRepositoryState(DefaultRepositorySystemSession repositorySystemSession,
                                         RepositorySystem repositorySystem, ArtifactResolver artifactResolver,
                                         VersionRangeResolver versionRangeResolver,
                                         RemoteRepositoryManager remoteRepositoryManager) {
    this.repositorySystemSession = repositorySystemSession;
    this.repositorySystem = repositorySystem;
    this.artifactResolver = artifactResolver;
    this.versionRangeResolver = versionRangeResolver;
    this.remoteRepositoryManager = remoteRepositoryManager;
  }

  @Override
  public DefaultRepositorySystemSession getSession() {
    return repositorySystemSession;
  }

  @Override
  public RepositorySystem getSystem() {
    return repositorySystem;
  }

  @Override
  public ModelResolver createModelResolver(List<RemoteRepository> repositories) {
    return new DefaultModelResolver(repositorySystemSession, artifactResolver,
                                    versionRangeResolver,
                                    getRemoteRepositoryManager(),
                                    repositories);
  }

  @Override
  public RemoteRepositoryManager getRemoteRepositoryManager() {
    return remoteRepositoryManager;
  }

}
