/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import org.mule.maven.client.api.model.MavenConfiguration;

import java.io.File;
import java.util.Optional;
import java.util.function.Consumer;

import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.repository.WorkspaceReader;

public class MuleMavenRepositoryStateFactory {

  private MuleMavenRepositoryStateFactory() {}

  public static MuleMavenRepositoryState createMavenRepositoryState(File localRepositoryLocation,
                                                                    MuleMavenResolutionContext muleMavenResolutionContext,
                                                                    MavenConfiguration mavenConfiguration,
                                                                    Optional<Consumer<DefaultRepositorySystemSession>> sessionConfigurator,
                                                                    Optional<WorkspaceReader> workspaceReader) {

    return new MuleMavenRepositoryState(localRepositoryLocation, workspaceReader,
                                        muleMavenResolutionContext.getAuthenticatorSelector(),
                                        muleMavenResolutionContext.getProxySelector(),
                                        muleMavenResolutionContext.getMirrorSelector(),
                                        muleMavenResolutionContext.getServerConfigurations(),
                                        mavenConfiguration.getForcePolicyUpdateNever(),
                                        mavenConfiguration.getForcePolicyUpdateAlways(),
                                        mavenConfiguration.getOfflineMode(),
                                        mavenConfiguration.getIgnoreArtifactDescriptorRepositories(),
                                        mavenConfiguration.getUserProperties(),
                                        sessionConfigurator.orElse(session -> {
                                        }),
                                        mavenConfiguration.getGlobalChecksumPolicy());
  }
}
