/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal;

import org.mule.maven.client.api.LocalRepositorySupplierFactory;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.PomFileSupplierFactory;

/**
 * {@link MavenClientProvider} implementation based on aether.
 */
public class MuleMavenClientProvider implements MavenClientProvider {

  @Override
  public MavenClient createMavenClient(MavenConfiguration mavenConfiguration) {
    return new MuleMavenClient(mavenConfiguration);
  }

  @Override
  public PomFileSupplierFactory getPomFileSuppliers() {
    return new DefaultPomFileSupplierFactory();
  }

  @Override
  public LocalRepositorySupplierFactory getLocalRepositorySuppliers() {
    return new DefaultLocalRepositorySupplierFactory();
  }

  @Override
  public SettingsSupplierFactory getSettingsSupplierFactory() {
    return new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
  }
}
