/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.internal.util;

/**
 * Utility method for checking preconditions.
 * <p>
 * We avoid adding libraries like guava to make this client lightweight.
 * 
 * @since 1.0
 */
public class Preconditions {

  /**
   * @param condition the condition to be meet so the state can be assumed correct.
   * @param message   the message to be used for creating the exception
   * 
   * @throws IllegalStateException if the conditions is not meet.
   */
  public static final void checkState(boolean condition, String message) {
    if (!condition) {
      throw new IllegalStateException(message);

    }
  }

  /**
   * @param object the object to check for null. @param message the message to be used for creating the exception.
   *
   * @throws IllegalArgumentException if the object is null.
   */
  public static final void checkNotNull(Object object, String message) {
    if (object == null) {
      throw new IllegalArgumentException(message);
    }
  }


}
