/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.File;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.mule.maven.client.internal.AetherServiceRegister;
import org.mule.maven.client.internal.MulePluginDependencyGraphTransformer;
import org.mule.maven.client.internal.MuleVersionSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherRepositoryState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherRepositoryState.class);
    private DefaultRepositorySystemSession session;
    private RepositorySystem system;

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean updatePolicyNever, boolean offline, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this(localRepositoryFolder, workspaceReader, offline, true, authenticationSelector, proxySelector, mirrorSelector, updatePolicyNever, sessionConfigurator);
    }

    public AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, boolean updatePolicyNever) {
        this(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, Optional.empty(), Optional.empty(), updatePolicyNever, _x -> {});
    }

    private AetherRepositoryState(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean updatePolicyNever, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.createRepositorySession(localRepositoryFolder, workspaceReader, offline, ignoreArtifactDescriptorRepositories, authenticationSelector, proxySelector, mirrorSelector, updatePolicyNever, sessionConfigurator);
    }

    private void createRepositorySession(File localRepositoryFolder, Optional<WorkspaceReader> workspaceReader, boolean offline, boolean ignoreArtifactDescriptorRepositories, Optional<AuthenticationSelector> authenticationSelector, Optional<ProxySelector> proxySelector, Optional<MirrorSelector> mirrorSelector, boolean updatePolicyNever, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.session = AetherRepositoryState.newDefaultRepositorySystemSession(updatePolicyNever, sessionConfigurator);
        RepositorySystem repositorySystem = this.createRepositorySystem();
        this.session.setLocalRepositoryManager(repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this.session, new LocalRepository(localRepositoryFolder)));
        this.session.setOffline(offline);
        proxySelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setProxySelector(arg_0));
        mirrorSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setMirrorSelector(arg_0));
        authenticationSelector.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setAuthenticationSelector(arg_0));
        ConflictResolver transformer = new ConflictResolver((ConflictResolver.VersionSelector)new MuleVersionSelector(new NearestVersionSelector()), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver());
        this.session.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new MulePluginDependencyGraphTransformer(), transformer, new JavaDependencyContextRefiner()}));
        this.session.setArtifactDescriptorPolicy((session, request) -> 0);
        this.session.setIgnoreArtifactDescriptorRepositories(ignoreArtifactDescriptorRepositories);
        workspaceReader.ifPresent(arg_0 -> ((DefaultRepositorySystemSession)this.session).setWorkspaceReader(arg_0));
        this.system = repositorySystem;
    }

    private RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                LOGGER.warn(exception.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(exception.getMessage(), exception);
                }
            }
        });
        this.loadAetherServiceRegister().ifPresent(aetherServiceRegister -> aetherServiceRegister.registerServices(locator));
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private Optional<AetherServiceRegister> loadAetherServiceRegister() {
        Iterator<AetherServiceRegister> iterator = ServiceLoader.load(AetherServiceRegister.class).iterator();
        if (iterator.hasNext()) {
            AetherServiceRegister serviceRegister = iterator.next();
            return Optional.of(serviceRegister);
        }
        return Optional.empty();
    }

    public DefaultRepositorySystemSession getSession() {
        return this.session;
    }

    public RepositorySystem getSystem() {
        return this.system;
    }

    private static DefaultRepositorySystemSession newDefaultRepositorySystemSession(boolean updatePolicyNever, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(1));
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        if (updatePolicyNever) {
            session.setUpdatePolicy("never");
        }
        session.setChecksumPolicy("ignore");
        session.setTransferListener((TransferListener)new LoggingTransferListener());
        sessionConfigurator.accept(session);
        return session;
    }

    private static final class LoggingTransferListener
    implements TransferListener {
        private LoggingTransferListener() {
        }

        public void transferSucceeded(TransferEvent event) {
            LOGGER.info("Transfer {} for '{}' from {}", new Object[]{event.getType(), event.getResource().getResourceName(), event.getResource().getRepositoryUrl()});
        }

        public void transferStarted(TransferEvent event) throws TransferCancelledException {
            LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
        }

        public void transferProgressed(TransferEvent event) throws TransferCancelledException {
            LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
        }

        public void transferInitiated(TransferEvent event) throws TransferCancelledException {
            LOGGER.trace("Transfer {} for '{}'", (Object)event.getType(), (Object)event.getResource().getResourceName());
        }

        public void transferFailed(TransferEvent event) {
            LOGGER.warn("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
        }

        public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
            LOGGER.warn("Transfer {} for '{}' ({})", new Object[]{event.getType(), event.getResource(), event.getException()});
        }
    }
}

