/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.is;

import org.junit.Test;

public class BadMavenConfigurationExceptionTestCase {

  @Test
  public void testBadMavenConfigurationExceptionMessage() {
    String expectedMessage = "Invalid Maven configuration";

    BadMavenConfigurationException exception = new BadMavenConfigurationException(expectedMessage);

    assertThat(exception.getMessage(), is(expectedMessage));
  }

  @Test
  public void testBadMavenConfigurationExceptionType() {
    String expectedMessage = "Invalid Maven configuration";

    BadMavenConfigurationException exception = new BadMavenConfigurationException(expectedMessage);

    assertThat(exception, instanceOf(BadMavenConfigurationException.class));
  }
}
