/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.api;

import java.io.File;
import java.util.function.Supplier;

/**
 * Provides a set of suppliers to be used to resolve maven repository folder.
 *
 * @since 1.0
 */
public interface LocalRepositorySupplierFactory {

  /**
   * @param folder to use as repository
   * @return a fixed supplier that will return the {@code folder} file as repository location.
   */
  Supplier<File> fixedFolderSupplier(File folder);

  /**
   * This supplier will try to resolve the repository folder based on environment configuration.
   * <p>
   * It will try to get the repository from the localRepository system property, if not set, then it will try to find the repo
   * from $USER_HOME/.m2/repository folder.
   *
   * @return a supplier that resolves the local repository based on environment configuration.
   */
  Supplier<File> environmentMavenRepositorySupplier();

  /**
   * Compose several suppliers in order. Once a supplier returns a not null value, that supplier value will be return.
   *
   * @param suppliers set of suppliers to compose
   *
   * @return a new supplier which is a composition of {@code #suppliers}
   */
  Supplier<File> composeSuppliers(Supplier<File>... suppliers);

}
