/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.maven.client.adapter1x;

import static java.util.stream.Collectors.toList;

import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.BundleScope;

import java.util.List;

class BundleUtils {

  public static BundleDependency dependencyTo1x(org.mule.maven.pom.parser.api.model.BundleDependency bundleDependency) {

    final BundleDependency.Builder builder = new BundleDependency.Builder();
    dependenciesTo1x(bundleDependency.getTransitiveDependencies())
        .forEach(builder::addTransitiveDependency);

    return builder
        .sedBundleDescriptor(descriptorTo1x(bundleDependency.getDescriptor()))
        .setBundleUri(bundleDependency.getBundleUri())
        .setDescriptor(descriptorTo1x(bundleDependency.getDescriptor()))
        .setScope(BundleScope.valueOf(bundleDependency.getScope().name()))
        .build();
  }

  public static List<BundleDependency> dependenciesTo1x(List<org.mule.maven.pom.parser.api.model.BundleDependency> bundleDependencies) {
    return bundleDependencies.stream()
        .map(BundleUtils::dependencyTo1x)
        .collect(toList());
  }

  public static BundleDescriptor descriptorTo1x(org.mule.maven.pom.parser.api.model.BundleDescriptor bundleDescriptor) {
    final BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
    if (bundleDescriptor.getBaseVersion() != null && !bundleDescriptor.getBaseVersion().equals("")) {
      builder.setBaseVersion(bundleDescriptor.getBaseVersion());
    }

    return builder
        .setGroupId(bundleDescriptor.getGroupId())
        .setArtifactId(bundleDescriptor.getArtifactId())
        .setVersion(bundleDescriptor.getVersion())
        .setType(bundleDescriptor.getType())
        .setClassifier(bundleDescriptor.getClassifier().orElse(null))
        .setProperties(bundleDescriptor.getProperties())
        .build();
  }

  public static org.mule.maven.pom.parser.api.model.BundleDescriptor descriptorFrom1x(BundleDescriptor bundleDescriptor) {
    final org.mule.maven.pom.parser.api.model.BundleDescriptor.Builder builder =
        new org.mule.maven.pom.parser.api.model.BundleDescriptor.Builder();
    if (bundleDescriptor.getBaseVersion() != null && !bundleDescriptor.getBaseVersion().equals("")) {
      builder.setBaseVersion(bundleDescriptor.getBaseVersion());
    }

    return builder
        .setGroupId(bundleDescriptor.getGroupId())
        .setArtifactId(bundleDescriptor.getArtifactId())
        .setVersion(bundleDescriptor.getVersion())
        .setType(bundleDescriptor.getType())
        .setClassifier(bundleDescriptor.getClassifier().orElse(null))
        .setProperties(bundleDescriptor.getProperties())
        .build();
  }

  public static List<org.mule.maven.pom.parser.api.model.BundleDescriptor> descriptorsFrom1x(List<BundleDescriptor> bundleDescriptors) {
    return bundleDescriptors.stream()
        .map(BundleUtils::descriptorFrom1x)
        .collect(toList());
  }
}
