/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.adapter1x;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Model;
import org.mule.maven.client.adapter1x.BundleUtils;
import org.mule.maven.client.api.LocalRepositorySupplierFactory;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.VersionRangeResult;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.MuleMavenClient;
import org.mule.maven.client.internal.MuleMavenClientProvider;

public class MavenClientProviderAdapter
implements MavenClientProvider {
    private final MuleMavenClientProvider adaptedProvider = new MuleMavenClientProvider();

    public MavenClient createMavenClient(MavenConfiguration mavenConfiguration) {
        final MuleMavenClient mavenClient = (MuleMavenClient)this.adaptedProvider.createMavenClient(mavenConfiguration);
        return new MavenClient(){

            public VersionRangeResult resolveVersionRange(BundleDescriptor bundleDescriptor) {
                return mavenClient.resolveVersionRange(BundleUtils.descriptorFrom1x(bundleDescriptor));
            }

            public List<BundleDependency> resolvePluginBundleDescriptorsDependencies(List<BundleDescriptor> bundleDescriptors) {
                return BundleUtils.dependenciesTo1x(mavenClient.resolvePluginBundleDescriptorsDependencies(BundleUtils.descriptorsFrom1x(bundleDescriptors)));
            }

            public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, boolean includeProvidedDependencies, BundleDescriptor bundleDescriptor) {
                return BundleUtils.dependenciesTo1x(mavenClient.resolveBundleDescriptorDependencies(includeTestDependencies, includeProvidedDependencies, BundleUtils.descriptorFrom1x(bundleDescriptor)));
            }

            public List<BundleDependency> resolveBundleDescriptorDependencies(boolean includeTestDependencies, BundleDescriptor bundleDescriptor) {
                return BundleUtils.dependenciesTo1x(mavenClient.resolveBundleDescriptorDependencies(includeTestDependencies, BundleUtils.descriptorFrom1x(bundleDescriptor)));
            }

            public BundleDependency resolveBundleDescriptor(BundleDescriptor bundleDescriptor) {
                return BundleUtils.dependencyTo1x(mavenClient.resolveBundleDescriptor(BundleUtils.descriptorFrom1x(bundleDescriptor)));
            }

            public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<MavenReactorResolver> mavenReactorResolver, Optional<File> temporaryFolder) {
                return BundleUtils.dependenciesTo1x(mavenClient.resolveArtifactDependencies(artifactFile, includeTestDependencies, includeProvidedDependencies, localRepositoryLocationSupplier, mavenReactorResolver, temporaryFolder));
            }

            public List<BundleDependency> resolveArtifactDependencies(File artifactFile, boolean includeTestDependencies, boolean includeProvidedDependencies, Optional<File> localRepositoryLocationSupplier, Optional<File> temporaryFolder) {
                return BundleUtils.dependenciesTo1x(mavenClient.resolveArtifactDependencies(artifactFile, includeTestDependencies, includeProvidedDependencies, localRepositoryLocationSupplier, temporaryFolder));
            }

            public List<BundleDependency> resolveArtifactDependencies(List<BundleDescriptor> dependencies, Optional<File> localRepositoryLocationSupplier, Optional<MavenReactorResolver> mavenReactorResolver) {
                return BundleUtils.dependenciesTo1x(mavenClient.resolveArtifactDependencies(BundleUtils.descriptorsFrom1x(dependencies), localRepositoryLocationSupplier, mavenReactorResolver));
            }

            public Model getRawPomModel(File artifactFile) {
                return null;
            }

            public MavenConfiguration getMavenConfiguration() {
                return mavenClient.getMavenConfiguration();
            }

            public Model getEffectiveModel(File artifactFile, Optional<File> temporaryFolder) {
                return null;
            }
        };
    }

    public PomFileSupplierFactory getPomFileSuppliers() {
        return this.adaptedProvider.getPomFileSuppliers();
    }

    public LocalRepositorySupplierFactory getLocalRepositorySuppliers() {
        return this.adaptedProvider.getLocalRepositorySuppliers();
    }

    public SettingsSupplierFactory getSettingsSupplierFactory() {
        return this.adaptedProvider.getSettingsSupplierFactory();
    }
}

