/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.encryption.key;

import java.security.Key;

/**
 * {@link EncryptionKeyFactory} which uses the same key for both encrypting and decrypting
 */
public interface SymmetricKeyFactory extends EncryptionKeyFactory {

  @Override
  default Key decryptionKey() {
    return encryptionKey();
  }

}
