/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.encryption;

import org.mule.encryption.exception.MuleEncryptionException;

import javax.crypto.Cipher;

public interface Encrypter {

  /**
   * Decrypts the given data
   */
  byte[] decrypt(byte[] data) throws MuleEncryptionException;

  /**
   * Encrypts the given data
   */
  byte[] encrypt(byte[] data) throws MuleEncryptionException;

  /**
   * @return The encryption transformation.
   * @see Cipher#getAlgorithm().
   */
  String getTransformation();
}
