/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.encryption.jce;

import javax.crypto.Cipher;

public class JCE {

  public static boolean isJCEInstalled() {
    try {
      int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
      return maxKeyLen > 256;
    } catch (java.security.NoSuchAlgorithmException e) {
      return false;
    }
  }
}
