/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;

public class ErrorNode {
    private ErrorModel errorModel;
    private List<ErrorNode> children;

    public ErrorNode(ErrorModel errorModel) {
        this.errorModel = errorModel;
        this.children = new ArrayList<ErrorNode>();
    }

    public Optional<ErrorModel> getErrorModel() {
        return Optional.ofNullable(this.errorModel);
    }

    public Stream<ErrorNode> getChildren() {
        return this.children.stream();
    }

    public void add(Iterator<ErrorModel> errorModelIterator, ErrorModel parentErrorModel) {
        ErrorModel newParentErrorModel;
        if (!errorModelIterator.hasNext()) {
            return;
        }
        ErrorModel errorModel = errorModelIterator.next();
        ErrorNode selectedErrorNode = this.children.stream().filter(errorNode -> {
            ErrorModel errorNodeErrorModel = errorNode.getErrorModel().orElseThrow(() -> new RuntimeException("ErrorModel not set"));
            return Objects.equals(errorNodeErrorModel.getNamespace(), errorModel.getNamespace()) && Objects.equals(errorNodeErrorModel.getType(), errorModel.getType());
        }).findFirst().orElse(null);
        if (selectedErrorNode == null) {
            ErrorModel errorModel1 = ErrorModelBuilder.newError((String)errorModel.getType(), (String)errorModel.getNamespace()).withParent(parentErrorModel).build();
            selectedErrorNode = new ErrorNode(errorModel1);
            this.children.add(selectedErrorNode);
            newParentErrorModel = errorModel1;
        } else {
            newParentErrorModel = selectedErrorNode.getErrorModel().orElse(null);
        }
        selectedErrorNode.add(errorModelIterator, newParentErrorModel);
    }

    public void accept(ErrorNodeVisitor errorNodeVisitor) {
        errorNodeVisitor.visit(this);
    }

    static interface ErrorNodeVisitor {
        public void visit(ErrorNode var1);
    }
}

