package org.mule.datasense.impl.util;

import org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;

public class Utils {

  @SafeVarargs
  public static <T> Optional<T> selectOptional(Supplier<Optional<T>>... optionals) {
    return Arrays.stream(optionals)
        .reduce((s1, s2) -> () -> s1.get().map(Optional::of).orElseGet(s2))
        .orElse(Optional::empty).get();
  }

  public static boolean isNullOrEmpty(@Nullable String string) {
    return string == null || string.length() == 0;
  }
}
