package org.mule.datasense.impl.util;

import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

import java.util.function.Consumer;

public class MuleFunctionTypeBuilder {

  private FunctionTypeBuilder functionTypeBuilder;

  public MuleFunctionTypeBuilder() {
    functionTypeBuilder = TypesHelper.getTypeBuilder().functionType();
  }

  public static MuleFunctionTypeBuilder builder() {
    return new MuleFunctionTypeBuilder();
  }

  public MuleFunctionTypeBuilder parameter(String name,
                                           Consumer<MuleEventMetadataTypeBuilder> muleEventMetadataTypeBuilderConsumer) {
    MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
    muleEventMetadataTypeBuilderConsumer.accept(muleEventMetadataTypeBuilder);
    functionTypeBuilder.addParameterOf(name, muleEventMetadataTypeBuilder);
    return this;
  }

  public MuleFunctionTypeBuilder returnType(Consumer<MuleEventMetadataTypeBuilder> muleEventMetadataTypeBuilderConsumer) {
    MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
    muleEventMetadataTypeBuilderConsumer.accept(muleEventMetadataTypeBuilder);
    functionTypeBuilder.returnType(muleEventMetadataTypeBuilder);
    return this;
  }

  public FunctionType build() {
    return functionTypeBuilder.build();
  }
}
