/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.tooling;

import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;

import java.util.Optional;

public class MetadataQueryResult implements TypedApplicationQueryResult {

  private final OperationModel operationModel;
  private final SourceModel sourceModel;

  public MetadataQueryResult(OperationModel operationModel, SourceModel sourceModel) {
    this.operationModel = operationModel;
    this.sourceModel = sourceModel;
  }

  public Optional<OperationModel> getOperationModel() {
    return Optional.ofNullable(operationModel);
  }

  public Optional<SourceModel> getSourceModel() {
    return Optional.ofNullable(sourceModel);
  }
}
