package org.mule.datasense.impl.phases.typing.resolver;

import static java.util.Optional.ofNullable;
import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;

import java.util.Optional;
import java.util.function.Consumer;

public class SetVariableTypeResolver extends SetMuleEventDataTypeResolver {

  private final static String FIELD_VARIABLE = "variableName";

  @Override
  protected Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode,
                                                                           EventType inputEventType,
                                                                           TypingMuleAstVisitor typingMuleAstVisitor,
                                                                           TypingMuleAstVisitorContext visitorContext) {
    return (muleEventExprBuilder) -> {
      getVarDeclName(messageProcessorNode).ifPresent(variableName -> {
        muleEventExprBuilder.variable(variableName, v -> {
          v.value(new ValueExprBuilder(resolveExprBuilder(messageProcessorNode)));
        });
      });
    };
  }

  private Optional<String> getVarDeclName(MessageProcessorNode messageProcessorNode) {
    return ofNullable((String) messageProcessorNode.getComponentModel().getParameter(DEFAULT_GROUP_NAME, FIELD_VARIABLE)
        .getValue().getRight());
  }
}
