package org.mule.datasense.impl.phases.typing.resolver;

import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.ExprBuilder;
import org.mule.datasense.impl.model.event.LiteralValueExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.util.extension.ExtensionUtils;
import org.mule.runtime.api.functional.Either;

public abstract class SetMuleEventDataTypeResolver extends SetDataTypeResolver {

  private final static String FIELD_VALUE = "value";

  protected Either<String, String> getFieldValue(MessageProcessorNode messageProcessorNode) {
    return messageProcessorNode.getComponentModel().getParameter(DEFAULT_GROUP_NAME, FIELD_VALUE).getValue();
  }

  protected ExprBuilder resolveExprBuilder(MessageProcessorNode messageProcessorNode) {
    final ExprBuilder result = getFieldValue(messageProcessorNode)
        .mapLeft(SimpleExprBuilder::new)
        .mapRight(LiteralValueExprBuilder::new)
        .<ExprBuilder>getValue()
        .orElseGet(() -> new LiteralValueExprBuilder(null));
    ExtensionUtils.findMimeType(messageProcessorNode.getComponentModel()).ifPresent(result::mimeType);
    return result;
  }

}
