package org.mule.datasense.impl.phases.typing.resolver;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_PARALLEL_FOREACH_SCOPE_IN;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.util.extension.ExtensionUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class ParallelForEachTypeResolver extends ForEachTypeResolver {

  private static final String DEFAULT_INDEX_VARIABLE_NAME = "index";

  @Override
  protected EventType resolveOutputEventType(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                                             EventType innerEventType, TypingMuleAstVisitor typingMuleAstVisitor,
                                             TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
    final ScatterGatherTypeResolver.CollectStrategy collectStrategy = new ScatterGatherTypeResolver.ListCollectStrategy();
    if (innerEventType != null) {
      collectStrategy.processMessageProcessorOutput(messageProcessorNode, innerEventType);
    }
    EventType outputEventType = collectStrategy.build();

    outputEventType = processTarget(outputEventType, messageProcessorNode, typingMuleAstVisitorContext);
    messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));

    return outputEventType;
  }

  @Override
  protected ComponentIdentifier getComponentIdentifierForeachScopeIn() {
    return COMPONENT_IDENTIFIER_PARALLEL_FOREACH_SCOPE_IN;
  }

  public static class ParallelForEachScopeIn extends ForEachTypeResolver.ForEachScopeIn {

    @Override
    protected String getDefaultCounterVariableName() {
      return DEFAULT_INDEX_VARIABLE_NAME;
    }
  }

  @Override
  protected EventType processTarget(EventType eventType, MessageProcessorNode messageProcessorNode,
                                    TypingMuleAstVisitorContext visitorContext) {
    final ComponentAst componentModel = messageProcessorNode.getComponentModel();
    final String target = ExtensionUtils.findTarget(componentModel).orElse(null);
    String targetValue = ExtensionUtils.findTargetValue(componentModel).orElse(null);
    final String mimeType = ExtensionUtils.findOutputMimeType(componentModel).orElse(null);

    //    if ("#[payload]".equals(targetValue)) {
    //      // TODO TOOLING- review metadata for parallel-foreach with target but no targetValue
    //      targetValue = null;
    //    }

    return targetProcessingSupport.processTarget(target, targetValue, mimeType, eventType, visitorContext,
                                                 createMessageCallbackFactory(
                                                                              visitorContext
                                                                                  .getAstNotification(),
                                                                              messageProcessorNode
                                                                                  .getAstNodeLocation()));
  }
}
