package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.impl.model.ast.DataSenseUnit;import org.mule.runtime.api.component.ComponentIdentifier;;

import java.util.function.Consumer;

public class DataSenseUnitBuilder {

  private MuleApplicationNodeBuilder muleApplicationNodeBuilder;

  public DataSenseUnitBuilder() {}

  public DataSenseUnitBuilder application(ComponentIdentifier componentIdentifier,
                                          Consumer<MuleApplicationNodeBuilder> muleApplicationNodeBuilderConsumer) {
    muleApplicationNodeBuilder = new MuleApplicationNodeBuilder(componentIdentifier);
    muleApplicationNodeBuilderConsumer.accept(muleApplicationNodeBuilder);
    return this;
  }

  public DataSenseUnit build() {
    return new DataSenseUnit(muleApplicationNodeBuilder.build());
  }
}
