/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingContext;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class ErrorHandlingEnvironment {
    private Deque<ErrorHandlingContext> errorHandlingContexts = new ArrayDeque<ErrorHandlingContext>();

    public void pushContext(String id) {
        this.pushContext(id, new ErrorHandlingContext(id));
    }

    public void pushContext(String id, EventType argumentEventType) {
        this.pushContext(id, new ErrorHandlingContext(id, argumentEventType));
    }

    private void pushContext(String id, ErrorHandlingContext errorHandlingContext) {
        this.errorHandlingContexts.push(errorHandlingContext);
    }

    public void popContext() {
        ErrorHandlingContext errorHandlingContext = this.errorHandlingContexts.pop();
        if (!this.errorHandlingContexts.isEmpty()) {
            this.throwErrors(errorHandlingContext.getUnhandledErrors());
        }
    }

    public ErrorHandlingContext getContext() {
        return this.errorHandlingContexts.peek();
    }

    public void enterErrorHandling() {
        this.getContext().close();
    }

    private ErrorHandlingContext findOpenContext() {
        for (ErrorHandlingContext errorHandlingContext : this.errorHandlingContexts) {
            if (!errorHandlingContext.isOpen()) continue;
            return errorHandlingContext;
        }
        throw new IllegalStateException();
    }

    public void throwErrors(Set<ErrorModel> errorModels) {
        this.findOpenContext().union(errorModels);
    }

    public void handleErrors(ErrorMatcher errorMatcher) {
        this.getContext().handle(errorMatcher);
    }
}

