/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.List;
import java.util.regex.Pattern;
import org.mule.datasense.impl.util.Parser;
import org.mule.datasense.impl.util.Parsers;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;

public class MetadataTypeReader {
    private static final String NUMBER_TYPE = "Number";
    private static final String STRING_TYPE = "String";
    private static final String BOOLEAN_TYPE = "Boolean";
    private static final String ANY_TYPE = "Any";
    private static final String BINARY_TYPE = "Binary";
    private static final String DATETIME_TYPE = "DateTime";
    private static final String DATE_TYPE = "Date";
    private static final String LOCALDATETIME_TYPE = "LocalDateTime";
    private static final String LOCALTIME_TYPE = "LocalTime";
    private static final String NOTHING_TYPE = "Nothing";
    private static final String NULL_TYPE = "Null";
    private static final String PERIOD_TYPE = "Period";
    private static final String TIMEZONE_TYPE = "TimeZone";
    static Parser<TypeBuilder> parseNumber = MetadataTypeReader.token("Number").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).numberType());
    static Parser<TypeBuilder> parseString = MetadataTypeReader.token("String").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).stringType());
    static Parser<TypeBuilder> parseBoolean = MetadataTypeReader.token("Boolean").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).booleanType());
    static Parser<TypeBuilder> parseAny = MetadataTypeReader.token("Any").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).anyType());
    static Parser<TypeBuilder> parseBinary = MetadataTypeReader.token("Binary").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).binaryType());
    static Parser<TypeBuilder> parseDateTime = MetadataTypeReader.token("DateTime").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).dateTimeType());
    static Parser<TypeBuilder> parseDate = MetadataTypeReader.token("Date").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).dateType());
    static Parser<TypeBuilder> parseLocalDateTime = MetadataTypeReader.token("LocalDateTime").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).localDateTimeType());
    static Parser<TypeBuilder> parseLocalTime = MetadataTypeReader.token("LocalTime").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).localTimeType());
    static Parser<TypeBuilder> parseNothing = MetadataTypeReader.token("Nothing").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).nothingType());
    static Parser<TypeBuilder> parseNull = MetadataTypeReader.token("Null").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).nullType());
    static Parser<TypeBuilder> parsePeriod = MetadataTypeReader.token("Period").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).periodType());
    static Parser<TypeBuilder> parseTimeZone = MetadataTypeReader.token("TimeZone").map(o -> new BaseTypeBuilder(MetadataFormat.JAVA).timeZoneType());
    static Parser<?> parseBs = Parsers.regex(Pattern.compile("[\\s\\r\\n]*"));
    static Parser<String> parseWord = Parsers.regex(Pattern.compile("([0-9a-zA-Z])+")).map(matchResult -> matchResult.group(0));
    static Parser<TypeBuilder> parseHeader = Parsers.skip(MetadataTypeReader.token("%type").then(MetadataTypeReader.token("_:"))).then(parseWord.map(format -> new BaseTypeBuilder(new MetadataFormat(format, format, null))));
    static Parser<TypeBuilder> parseBasicType = parseString.or(parseBoolean).or(parseNumber).or(parseAny).or(parseBinary).or(parseDateTime).or(parseDate).or(parseLocalDateTime).or(parseLocalTime).or(parseNothing).or(parseNull).or(parsePeriod).or(parseTimeZone);
    static Parser<TypeBuilder> parseArray = Parsers.skip(MetadataTypeReader.token("[")).then(() -> parseType).skip(MetadataTypeReader.token("]")).map(typeBuilder -> {
        ArrayTypeBuilder arrayTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType();
        return arrayTypeBuilder.of(typeBuilder);
    });
    static Parser<TypeBuilder> parseUnion = Parsers.skip(Parsers.begin()).then(() -> parseTypeWithoutUnionOrIntersection).twoOrMore(MetadataTypeReader.token("|")).map(typeBuilders -> {
        UnionTypeBuilder unionTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).unionType();
        typeBuilders.forEach(arg_0 -> ((UnionTypeBuilder)unionTypeBuilder).of(arg_0));
        return unionTypeBuilder;
    });
    static Parser<TypeBuilder> parseIntersection = Parsers.skip(Parsers.begin()).then(() -> parseTypeWithoutUnionOrIntersection).twoOrMore(MetadataTypeReader.token("&")).map(typeBuilders -> {
        IntersectionTypeBuilder intersectionTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).intersectionType();
        typeBuilders.forEach(arg_0 -> ((IntersectionTypeBuilder)intersectionTypeBuilder).of(arg_0));
        return intersectionTypeBuilder;
    });
    static Parser<TypeBuilder> parseParenthesis = Parsers.skip(MetadataTypeReader.token("(")).then(() -> parseType).skip(MetadataTypeReader.token(")"));
    static Parser<String> parseAnnotationKey = parseWord;
    static Parser<String> parseAnnotationValue = parseWord;
    static Parser<Parsers.Pair<String, String>> parseAnnotationProperty = parseAnnotationKey.skip(MetadataTypeReader.token(":")).then(parseAnnotationValue);
    static Parser<List<Parsers.Pair<String, String>>> parseAnnotationProperties = parseAnnotationProperty.oneOrMore(MetadataTypeReader.token(","));
    static Parser<TypeAnnotation> parseAnnotation = Parsers.skip(MetadataTypeReader.token("@")).then(parseWord).skip(MetadataTypeReader.token("(")).then(parseAnnotationProperties).skip(MetadataTypeReader.token(")")).map(stringListPair -> {
        String annotation = (String)stringListPair.first;
        List annotationProperties = (List)stringListPair.second;
        return new DefaultValueAnnotation("");
    });
    static Parser<String> parseKey = parseWord;
    static Parser<TypeBuilder> parseValue = Parsers.skip(Parsers.begin()).then(() -> parseType);
    static Parser<Parsers.Pair<String, TypeBuilder>> parseKeyValue = parseKey.skip(MetadataTypeReader.token(":")).then(parseValue);
    static Parser<List<Parsers.Pair<String, TypeBuilder>>> parseKeyValues = parseKeyValue.oneOrMore(MetadataTypeReader.token(","));
    static Parser<TypeBuilder> parseObject = Parsers.skip(MetadataTypeReader.token("{")).skip(parseAnnotation.optional()).then(() -> parseKeyValues).skip(MetadataTypeReader.token("}")).map(pairs -> {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        pairs.forEach(stringTypeBuilderPair -> {
            String key = (String)stringTypeBuilderPair.first;
            TypeBuilder typeBuilder = (TypeBuilder)stringTypeBuilderPair.second;
            objectTypeBuilder.addField().key(key).value(typeBuilder);
        });
        return objectTypeBuilder;
    });
    static Parser<TypeBuilder> parseTuple = Parsers.skip(MetadataTypeReader.token("<")).then(() -> parseType.oneOrMore(MetadataTypeReader.token(","))).skip(MetadataTypeReader.token(">")).map(typeBuilders -> {
        TupleTypeBuilder tupleTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).tupleType();
        typeBuilders.forEach(arg_0 -> ((TupleTypeBuilder)tupleTypeBuilder).of(arg_0));
        return tupleTypeBuilder;
    });
    static Parser<TypeBuilder> parseType = parseUnion.or(parseIntersection).or(parseParenthesis).or(parseArray).or(parseBasicType);
    static Parser<TypeBuilder> parseTypeWithoutUnionOrIntersection = parseArray.or(parseParenthesis).or(parseBasicType);
    static Parser<TypeBuilder> parseMetadataTypeDefinition = parseHeader.skip(parseBs.then(MetadataTypeReader.token("=").then(parseBs))).then(parseType).map(typeBuilderTypeBuilderPair -> (TypeBuilder)typeBuilderTypeBuilderPair.second);
    public static Parser<TypeBuilder> parse = Parsers.skip(Parsers.begin()).then(parseMetadataTypeDefinition).skip(Parsers.end());

    static Parser<?> token(String keyword) {
        return Parsers.regex(Pattern.quote(keyword) + "[\\s\\r\\n]*");
    }
}

