package org.mule.datasense.impl.util.extension;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;

import java.util.Optional;
import java.util.function.Function;

public class OutputModelTransform {

  private Function<OutputModel, MetadataType> typeTransform;

  public OutputModelTransform() {
    this(null);
  }

  public OutputModelTransform(
                              Function<OutputModel, MetadataType> typeTransform) {
    this.typeTransform = typeTransform;
  }

  private Optional<Function<OutputModel, MetadataType>> getTypeTransform() {
    return Optional.ofNullable(typeTransform);
  }

  public OutputModel transform(OutputModel outputModel) {
    return new ImmutableOutputModel(outputModel.getDescription(), getTypeTransform()
        .map(outputModelMetadataTypeFunction -> outputModelMetadataTypeFunction.apply(outputModel)).orElse(outputModel.getType()),
                                    outputModel.hasDynamicType(), outputModel.getModelProperties());
  }
}
