package org.mule.datasense.impl.phases.typing.resolver;

import static java.util.Optional.of;
import static org.mule.runtime.api.meta.model.parameter.ParameterGroupModel.DEFAULT_GROUP_NAME;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

import java.util.Optional;

public class RemoveVariableTypeResolver extends SingleNodeTypeResolver {

  private final static String FIELD_VARIABLE = "variableName";

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext visitorContext) {
    final MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();

    getVarDeclName(messageProcessorNode).ifPresent(variableName -> {
      muleEventMetadataTypeBuilder.addVariable(variableName).voidType();
    });
    EventType definesEventType = TypeUtils.asEventType(muleEventMetadataTypeBuilder.build());
    messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
    messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
    return definesEventType;
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }

  protected Optional<String> getVarDeclName(MessageProcessorNode messageProcessorNode) {
    return of((String) messageProcessorNode.getComponentModel().getParameter(DEFAULT_GROUP_NAME, FIELD_VARIABLE).getValue()
        .getRight());
  }

}
