package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;

import java.util.stream.Stream;

public class SourceAnnotator extends BaseCompositeAnnotator {

  public SourceAnnotator() {
    super(Stream.of(/*new StaticSourceAnnotator(),*/ new StaticDslSourceAnnotator(), new DynamicSourceAnnotator(),
                    new OperationCallCustomizerAnnotator()));
  }

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    getAnnotators().forEach(annotator -> annotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext));
  }
}
