package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;

import java.util.stream.Stream;

public class OperationAnnotator extends BaseCompositeAnnotator {

  public OperationAnnotator() {
    super(Stream.of(/*new StaticOperationAnnotator(),*/ new StaticDslOperationAnnotator(), new DynamicOperationAnnotator(),
                    new OperationCallCustomizerAnnotator()));
  }

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    getAnnotators().forEach(annotator -> annotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext));
  }
}
