package org.mule.datasense.impl.model.types;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MetadataTypeUnification {

  public Optional<Map<String, MetadataType>> unify(MetadataType metadataType1, MetadataType metadataType2) {
    if (metadataType1 instanceof TypeParameterType) {
      final Map<String, MetadataType> substitutions = new HashMap<>();
      substitutions.put(((TypeParameterType) metadataType1).getName(), metadataType2);
      return Optional.of(substitutions);
    } else if (metadataType2 instanceof TypeParameterType) {
      final Map<String, MetadataType> substitutions = new HashMap<>();
      substitutions.put(((TypeParameterType) metadataType2).getName(), metadataType1);
      return Optional.of(substitutions);
    } else if (metadataType1 instanceof DefaultAnyType && metadataType2 instanceof DefaultAnyType) {
      return Optional.of(Collections.emptyMap());
    } else if (metadataType1 instanceof DefaultArrayType && metadataType2 instanceof DefaultArrayType) {
      return unifyArrayTypes((DefaultArrayType) metadataType1, (DefaultArrayType) metadataType2);
    } else if (metadataType1 instanceof SimpleType && metadataType2 instanceof SimpleType) {
      return Optional.of(Collections.emptyMap());
    }
    /*
    else if (metadataType1 instanceof DefaultObjectType && metadataType2 instanceof DefaultObjectType) {
      return unifyObject((DefaultObjectType) metadataType1, (DefaultObjectType) metadataType2);
    }
        else if (metadataType1 instanceof DefaultTupleType && metadataType2 instanceof DefaultTupleType) {
            return visitTuple((DefaultTupleType) metadataType);
        }
        else if (metadataType1 instanceof DefaultUnionType && metadataType2 instanceof DefaultUnionType) {
            return visitUnion((DefaultUnionType) metadataType);
        }
        else if (metadataType1 instanceof DefaultIntersectionType && metadataType2 instanceof DefaultIntersectionType) {
            return visitIntersection((DefaultIntersectionType) metadataType);
        }
        else if (metadataType1 instanceof DefaultObjectKeyType && metadataType2 instanceof DefaultObjectKeyType) {
            return visitObjectKey((DefaultObjectKeyType) metadataType);
        }
        else if (metadataType1 instanceof DefaultAttributeKeyType && metadataType2 instanceof DefaultAttributeKeyType) {
            return visitAttributeKey((DefaultAttributeKeyType) metadataType);
        }
        else if (metadataType1 instanceof DefaultAttributeFieldType && metadataType2 instanceof DefaultAttributeFieldType) {
            return visitAttributeField((DefaultAttributeFieldType) metadataType);
        }
        else if (metadataType1 instanceof DefaultObjectFieldType && metadataType2 instanceof DefaultObjectFieldType) {
            return visitObjectField((DefaultObjectFieldType) metadataType);
        }
        else if (metadataType1 instanceof DefaultNothingType && metadataType2 instanceof DefaultNothingType) {
            return visitNothing((DefaultNothingType) metadataType);
        }
        else if (metadataType1 instanceof DefaultFunctionType && metadataType2 instanceof DefaultFunctionType) {
            return visitFunction((DefaultFunctionType) metadataType);
        }
        else if (metadataType1 instanceof DefaultLocalDateTimeType && metadataType2 instanceof DefaultLocalDateTimeType) {
            return visitLocalDateTime((DefaultLocalDateTimeType) metadataType);
        }
        else if (metadataType1 instanceof DefaultLocalTimeType && metadataType2 instanceof DefaultLocalTimeType) {
            return visitLocalTime((DefaultLocalTimeType) metadataType);
        }
        else if (metadataType1 instanceof DefaultPeriodType && metadataType2 instanceof DefaultPeriodType) {
            return visitPeriod((DefaultPeriodType) metadataType);
        }
        else if (metadataType1 instanceof DefaultRegexType && metadataType2 instanceof DefaultRegexType) {
            return visitRegex((DefaultRegexType) metadataType);
        }
        else if (metadataType1 instanceof DefaultTimeZoneType && metadataType2 instanceof DefaultTimeZoneType) {
            return visitTimeZone((DefaultTimeZoneType) metadataType);
        }
    */
    else {
      return Optional.empty();
    }
  }

  private Optional<Map<String, MetadataType>> unifyArrayTypes(DefaultArrayType arrayType1, DefaultArrayType arrayType2) {
    return unify(arrayType1.getType(), arrayType2.getType());
  }
  /*
  protected MetadataType transformArrayType(Supplier<MetadataType> type, MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultArrayType(type, metadataFormat, extensions);
  }
  */

  /*
    private MetadataType transformBinaryType(DefaultBinaryType binaryType) {
        return transformBinaryType(binaryType.getMetadataFormat(), binaryType.getExtensions());
    }
  
    protected MetadataType transformBinaryType(MetadataFormat metadataFormat,
                                               Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultBinaryType(metadataFormat, extensions);
    }
  
    private MetadataType transformBoolean(DefaultBooleanType booleanType) {
        return transformBoolean(booleanType.getMetadataFormat(), booleanType.getExtensions());
    }
  
    protected MetadataType transformBoolean(MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultBooleanType(metadataFormat, extensions);
    }
  
    private MetadataType visitDateTime(DefaultDateTimeType dateTimeType) {
        return transformDateTime(dateTimeType.getMetadataFormat(), dateTimeType.getExtensions());
    }
  
    protected MetadataType transformDateTime(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultDateTimeType(metadataFormat, extensions);
    }
  
    private MetadataType visitDate(DefaultDateType dateType) {
        return transformDateType(dateType.getMetadataFormat(), dateType.getExtensions());
    }
  
    protected MetadataType transformDateType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultDateType(metadataFormat, extensions);
    }
  
    private MetadataType visitNull(DefaultNullType nullType) {
        return transformNullType(nullType.getMetadataFormat(), nullType.getExtensions());
    }
  
    protected MetadataType transformNullType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultNullType(metadataFormat, extensions);
    }
  
    private MetadataType visitVoid(DefaultVoidType voidType) {
        return transformVoidType(voidType.getMetadataFormat(), voidType.getExtensions());
    }
  
    protected MetadataType transformVoidType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultVoidType(metadataFormat, extensions);
    }
  
    private MetadataType visitNumber(DefaultNumberType numberType) {
        return transformNumberType(numberType.getMetadataFormat(), numberType.getExtensions());
    }
  
    protected MetadataType transformNumberType(MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultNumberType(metadataFormat, extensions);
    }
  */

  /*
  private Optional<Map<String, MetadataType>> visitObject(DefaultObjectType objectType1, DefaultObjectType objectType2) {
    final Supplier<List<ObjectFieldType>> fields = ()->objectType.getFields().stream().map(objectFieldType -> (ObjectFieldType) transform(objectFieldType)).collect(Collectors.toList());
    return transformObjectType(fields, objectType.isOrdered(), objectType.getOpenRestriction().map(this::transform).orElse(null), objectType.getMetadataFormat(), objectType.getExtensions());
  }
  
  protected MetadataType transformObjectType(Supplier<List<ObjectFieldType>> fields, boolean ordered, MetadataType openRestriction,
                                             MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    return new DefaultObjectType(fields.get(), ordered, openRestriction, metadataFormat, extensions);
  }
  */

  /*
  
    private MetadataType visitString(DefaultStringType stringType) {
        return transformStringType(stringType.getMetadataFormat(), stringType.getExtensions());
    }
  
    protected MetadataType transformStringType(MetadataFormat metadataFormat,
                                             Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultStringType(metadataFormat, extensions);
    }
  
    private MetadataType visitTime(DefaultTimeType timeType) {
        return transformTimeType(timeType.getMetadataFormat(), timeType.getExtensions());
    }
  
    protected MetadataType transformTimeType(MetadataFormat metadataFormat,
                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTimeType(metadataFormat, extensions);
    }
  
    private MetadataType visitTuple(DefaultTupleType tupleType) {
        final Supplier<List<MetadataType>> types = ()->tupleType.getTypes().stream().map(this::transform).collect(Collectors.toList());
        return transformTupleType(types, tupleType.getMetadataFormat(), tupleType.getExtensions());
    }
  
    protected MetadataType transformTupleType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTupleType(types.get(), metadataFormat, extensions);
    }
  
    private MetadataType visitUnion(DefaultUnionType unionType) {
        final Supplier<List<MetadataType>> types = ()->unionType.getTypes().stream().map(this::transform).collect(Collectors.toList());
        return transformUnionType(types, unionType.getMetadataFormat(), unionType.getExtensions());
    }
  
    protected MetadataType transformUnionType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat,
                                            Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultUnionType(types.get(), metadataFormat, extensions);
    }
  
    private MetadataType visitIntersection(DefaultIntersectionType intersectionType) {
        final Supplier<List<MetadataType>> types = ()->intersectionType.getTypes().stream().map(this::transform).collect(Collectors.toList());
        return transformIntersectionType(types, intersectionType.getMetadataFormat(), intersectionType.getExtensions());
    }
  
    protected MetadataType transformIntersectionType(Supplier<List<MetadataType>> types, MetadataFormat metadataFormat,
                                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultIntersectionType(types.get(), metadataFormat, extensions);
    }
  
    private MetadataType visitObjectKey(DefaultObjectKeyType objectKeyType) {
        final Supplier<List<AttributeFieldType>> attributes = ()->
            objectKeyType.getAttributes().stream().map(attributeFieldType -> (AttributeFieldType) transform(attributeFieldType))
                .collect(Collectors.toList());
        final Optional<QName> name = Optional.ofNullable(objectKeyType.isName() ? objectKeyType.getName() : null);
        final Optional<Pattern> pattern = Optional.ofNullable(objectKeyType.isPattern() ? objectKeyType.getPattern() : null);
        return transformObjectKeyType(name, pattern, attributes, objectKeyType.getMetadataFormat(), objectKeyType.getExtensions());
    }
  
    protected MetadataType transformObjectKeyType(Optional<QName> name, Optional<Pattern> pattern,
                                                Supplier<List<AttributeFieldType>> attributes,
                                                MetadataFormat metadataFormat,
                                                Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultObjectKeyType(name, pattern, attributes.get(), metadataFormat, extensions);
    }
  
    private MetadataType visitAttributeKey(DefaultAttributeKeyType attributeKeyType) {
        final Optional<QName> name = Optional.ofNullable(attributeKeyType.isName() ? attributeKeyType.getName() : null);
        final Optional<Pattern> pattern = Optional.ofNullable(attributeKeyType.isPattern() ? attributeKeyType.getPattern() : null);
        return transformAttributeKeyType(name, pattern, attributeKeyType.getMetadataFormat(), attributeKeyType.getExtensions());
    }
  
    protected MetadataType transformAttributeKeyType(Optional<QName> name, Optional<Pattern> pattern, MetadataFormat metadataFormat,
                                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultAttributeKeyType(name, pattern, metadataFormat, extensions);
    }
  
    private MetadataType visitAttributeField(DefaultAttributeFieldType attributeFieldType) {
        return transformAttributeFieldType(()->(AttributeKeyType) transform(attributeFieldType.getKey()), ()->(SimpleType) transform(attributeFieldType.getValue()), attributeFieldType.isRequired(),
                                             attributeFieldType.getMetadataFormat(), attributeFieldType.getExtensions());
    }
  
    protected MetadataType transformAttributeFieldType(Supplier<AttributeKeyType> key, Supplier<SimpleType> value, boolean required,
                                                     MetadataFormat metadataFormat,
                                                     Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultAttributeFieldType(key.get(), value.get(), required, metadataFormat, extensions);
    }
  
    private MetadataType visitObjectField(DefaultObjectFieldType objectFieldType) {
        return transformDefaultObjectFieldType(()->(ObjectKeyType) transform(objectFieldType.getKey()), ()->transform(objectFieldType.getValue()), objectFieldType.isRequired(), objectFieldType.isRepeated(),
                                          objectFieldType.getMetadataFormat(), objectFieldType.getExtensions());
    }
  
    protected MetadataType transformDefaultObjectFieldType(Supplier<ObjectKeyType> key, Supplier<MetadataType> value, boolean required,
                                                         boolean repeated, MetadataFormat metadataFormat,
                                                         Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultObjectFieldType(key.get(), value.get(), required, repeated, metadataFormat, extensions);
    }
  
    private MetadataType visitNothing(DefaultNothingType nothingType) {
        return transformNothingType(nothingType.getMetadataFormat(), nothingType.getExtensions());
    }
  
    protected MetadataType transformNothingType(MetadataFormat metadataFormat,
                                              Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultNothingType(metadataFormat, extensions);
    }
  
    private MetadataType visitFunction(DefaultFunctionType functionType) {
        final Supplier<List<FunctionParameter>> functionParameters = ()-> functionType.getParameters().stream()
            .map(functionParameter -> new FunctionParameter(functionParameter.getName(), transform(functionParameter.getType())))
            .collect(
                Collectors.toList());
        final Supplier<Optional<MetadataType>> returnType = ()->functionType.getReturnType().map(this::transform);
        return transformFunctionType(functionType.getMetadataFormat(), functionType.getExtensions(), returnType, functionParameters);
    }
  
    protected MetadataType transformFunctionType(MetadataFormat metadataFormat,
                                               Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions,
                                               Supplier<Optional<MetadataType>> returnType, Supplier<List<FunctionParameter>> functionParameters) {
        return new DefaultFunctionType(metadataFormat, extensions, returnType.get(), functionParameters.get());
    }
  
    private MetadataType visitLocalDateTime(DefaultLocalDateTimeType localDateTimeType) {
        return transformLocalDateTimeType(localDateTimeType.getMetadataFormat(), localDateTimeType.getExtensions());
    }
  
    protected MetadataType transformLocalDateTimeType(MetadataFormat metadataFormat,
                                                    Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultLocalDateTimeType(metadataFormat, extensions);
    }
  
    private MetadataType visitLocalTime(DefaultLocalTimeType localTimeType) {
        return transformLocalTimeType(localTimeType.getMetadataFormat(), localTimeType.getExtensions());
    }
  
    protected MetadataType transformLocalTimeType(MetadataFormat metadataFormat,
                                                Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultLocalTimeType(metadataFormat, extensions);
    }
  
    private MetadataType visitPeriod(DefaultPeriodType periodType) {
        return transformDefaultPeriodType(periodType.getMetadataFormat(), periodType.getExtensions());
    }
  
    protected MetadataType transformDefaultPeriodType(MetadataFormat metadataFormat,
                                                    Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultPeriodType(metadataFormat, extensions);
    }
  
    private MetadataType visitRegex(DefaultRegexType regexType) {
        return transformDefaultRegexType(regexType.getMetadataFormat(), regexType.getExtensions());
    }
  
    protected MetadataType transformDefaultRegexType(MetadataFormat metadataFormat,
                                                   Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultRegexType(metadataFormat, extensions);
    }
  
    private MetadataType visitTimeZone(DefaultTimeZoneType timeZoneType) {
        return transformDefaultTimeZoneType(timeZoneType.getMetadataFormat(), timeZoneType.getExtensions());
    }
  
    protected MetadataType transformDefaultTimeZoneType(MetadataFormat metadataFormat,
                                                      Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTimeZoneType(metadataFormat, extensions);
    }
  
    private MetadataType visitTypeParameter(DefaultTypeParameterType defaultTypeParameter) {
        return transformDefaultTypeParameterType(defaultTypeParameter.getName(), defaultTypeParameter.getMetadataFormat(), defaultTypeParameter.getExtensions());
    }
  
    protected MetadataType transformDefaultTypeParameterType(String name, MetadataFormat metadataFormat,
                                                           Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        return new DefaultTypeParameterType(name, metadataFormat, extensions);
    }
  */
}
