package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

import java.util.Optional;

public class MessageExpr implements DefElemValueExpr {

  private final Optional<Expr> payload;
  private final Optional<Expr> attributes;

  public MessageExpr(Expr payload, Expr attributes) {
    this.payload = Optional.ofNullable(payload);
    this.attributes = Optional.ofNullable(attributes);
  }

  public MessageMetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                         ResolveTypeContext resolveTypeContext) {
    MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
    payload.ifPresent(expr -> {
      messageMetadataTypeBuilder.payload(expr.resolveType(muleEventMetadataType, resolveTypeContext));
    });
    attributes.ifPresent(expr -> {
      messageMetadataTypeBuilder.attributes(expr.resolveType(muleEventMetadataType, resolveTypeContext));
    });
    return messageMetadataTypeBuilder.build();
  }

  @Override
  public void resolveInputType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               MetadataType metadataType, ResolveTypeContext resolveTypeContext) {
    final Optional<MessageMetadataType> messageType =
        Optional.ofNullable(metadataType instanceof MessageMetadataType ? (MessageMetadataType) metadataType : null);
    payload.ifPresent(expr -> {
      final MetadataType payloadType = messageType.flatMap(messageMetadataType -> messageMetadataType.getPayloadType())
          .orElse(TypesHelper.getTypeBuilder().anyType().build());
      expr.resolveInputType(payloadType, muleEventMetadataTypeBuilder, resolveTypeContext);
    });
    attributes.ifPresent(expr -> {
      final MetadataType attributesType = messageType.flatMap(messageMetadataType -> messageMetadataType.getAttributesType())
          .orElse(TypesHelper.getTypeBuilder().anyType().build());
      expr.resolveInputType(attributesType, muleEventMetadataTypeBuilder, resolveTypeContext);
    });
  }
}
