package org.mule.datasense.impl.model.annotations;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.types.EventType;

public class UsesTypeAnnotation implements AstNodeAnnotation {

  private EventType usesEventType;

  public UsesTypeAnnotation(EventType usesEventType) {
    Preconditions.checkNotNull(usesEventType);
    this.usesEventType = usesEventType;
  }

  public EventType getUsesEventType() {
    return usesEventType;
  }

  public void overrideWith(EventType eventType) {
    this.usesEventType = eventType;
  }
}
