package org.mule.datasense.api.metadataprovider;

import static java.util.stream.Collectors.toSet;

import org.mule.datasenseapi.api.metadataprovider.DefaultExtensionsProvider;
import org.mule.datasenseapi.api.metadataprovider.ExtensionsProvider;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;

import java.util.Set;

public class ExtensionsProviderFromJson {

  public ExtensionsProvider create(Set<String> extensionModelJsonData) {
    ExtensionModelJsonSerializer extensionModelJsonSerializer = new ExtensionModelJsonSerializer();
    return new DefaultExtensionsProvider(extensionModelJsonData.stream()
        .map(extensionModelJsonSerializer::deserialize)
        .collect(toSet()));
  }
}
